/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

interface IMessengerCompat
extends IInterface {
    public static final String DESCRIPTOR = "com.google.android.gms.iid.IMessengerCompat";
    public static final int TRANSACTION_SEND = 1;

    public void send(@NonNull Message var1) throws RemoteException;

    public static class Impl
    extends Binder
    implements IMessengerCompat {
        @Override
        public void send(@NonNull Message message) throws RemoteException {
            message.arg2 = Binder.getCallingUid();
            null.dispatchMessage(message);
        }

        public boolean onTransact(int n, @NonNull Parcel parcel, @Nullable Parcel parcel2, int n2) throws RemoteException {
            parcel.enforceInterface(this.getInterfaceDescriptor());
            if (n == 1) {
                Message message = parcel.readInt() != 0 ? (Message)Message.CREATOR.createFromParcel(parcel) : null;
                this.send(message);
                return true;
            }
            return false;
        }

        @Override
        @NonNull
        public IBinder asBinder() {
            return this;
        }
    }

    public static class Proxy
    implements IMessengerCompat {
        private final IBinder zza;

        Proxy(@NonNull IBinder iBinder) {
            this.zza = iBinder;
        }

        @Override
        public void send(@NonNull Message message) throws RemoteException {
            Parcel parcel = Parcel.obtain();
            parcel.writeInterfaceToken(IMessengerCompat.DESCRIPTOR);
            parcel.writeInt(1);
            message.writeToParcel(parcel, 0);
            try {
                this.zza.transact(1, parcel, null, 1);
                return;
            }
            finally {
                parcel.recycle();
            }
        }

        @Override
        @NonNull
        public IBinder asBinder() {
            return this.zza;
        }
    }
}

