/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;

@KeepForSdk
public class ServiceStarter {
    @KeepForSdk
    public static final int ERROR_UNKNOWN = 500;
    public static final String ACTION_MESSAGING_EVENT = "com.google.firebase.MESSAGING_EVENT";
    private static ServiceStarter instance;
    private Boolean hasWakeLockPermission = null;
    private Boolean hasAccessNetworkStatePermission = null;

    @KeepForSdk
    public static synchronized ServiceStarter getInstance() {
        if (instance == null) {
            ServiceStarter serviceStarter;
            instance = serviceStarter = new ServiceStarter();
        }
        return instance;
    }

    private ServiceStarter() {
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasWakeLockPermission(Context context) {
        if (this.hasWakeLockPermission == null) {
            boolean bl = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
            this.hasWakeLockPermission = bl;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasWakeLockPermission;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasAccessNetworkStatePermission(Context context) {
        if (this.hasAccessNetworkStatePermission == null) {
            boolean bl = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
            this.hasAccessNetworkStatePermission = bl;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasAccessNetworkStatePermission;
    }

    @VisibleForTesting
    public static void setForTesting(ServiceStarter serviceStarter) {
        instance = serviceStarter;
    }
}

