/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.SheetDefaultsKt;
import androidx.compose.material3.SheetValue;
import androidx.compose.material3.internal.AnchoredDraggableKt;
import androidx.compose.material3.internal.AnchoredDraggableState;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverKt;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 52\u00020\u0001:\u00015BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010 \u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010!\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020\u0017H\u0080@\u00a2\u0006\u0004\b$\u0010%J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\b'\u0010(J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0017H\u0080@\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u00010\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Landroidx/compose/material3/SheetState;", "", "skipPartiallyExpanded", "", "density", "Landroidx/compose/ui/unit/Density;", "initialValue", "Landroidx/compose/material3/SheetValue;", "confirmValueChange", "Lkotlin/Function1;", "skipHiddenState", "<init>", "(ZLandroidx/compose/ui/unit/Density;Landroidx/compose/material3/SheetValue;Lkotlin/jvm/functions/Function1;Z)V", "getSkipPartiallyExpanded$material3", "()Z", "getSkipHiddenState$material3", "currentValue", "getCurrentValue", "()Landroidx/compose/material3/SheetValue;", "targetValue", "getTargetValue", "isVisible", "requireOffset", "", "hasExpandedState", "getHasExpandedState", "hasPartiallyExpandedState", "getHasPartiallyExpandedState", "expand", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "partialExpand", "show", "hide", "animateTo", "velocity", "animateTo$material3", "(Landroidx/compose/material3/SheetValue;FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapTo", "snapTo$material3", "(Landroidx/compose/material3/SheetValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "settle", "settle$material3", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "anchoredDraggableState", "Landroidx/compose/material3/internal/AnchoredDraggableState;", "getAnchoredDraggableState$material3", "()Landroidx/compose/material3/internal/AnchoredDraggableState;", "setAnchoredDraggableState$material3", "(Landroidx/compose/material3/internal/AnchoredDraggableState;)V", "offset", "getOffset$material3", "()Ljava/lang/Float;", "Companion", "material3"})
@Stable
@ExperimentalMaterial3Api
@SourceDebugExtension(value={"SMAP\nSheetDefaults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SheetDefaults.kt\nandroidx/compose/material3/SheetState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,437:1\n1#2:438\n113#3:439\n113#3:440\n*S KotlinDebug\n*F\n+ 1 SheetDefaults.kt\nandroidx/compose/material3/SheetState\n*L\n244#1:439\n245#1:440\n*E\n"})
public final class SheetState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean skipPartiallyExpanded;
    private final boolean skipHiddenState;
    @NotNull
    private AnchoredDraggableState<SheetValue> anchoredDraggableState;
    public static final int $stable;

    public SheetState(boolean skipPartiallyExpanded, @NotNull Density density, @NotNull SheetValue initialValue, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange, boolean skipHiddenState) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
        this.skipPartiallyExpanded = skipPartiallyExpanded;
        this.skipHiddenState = skipHiddenState;
        if (this.skipPartiallyExpanded && !(initialValue != SheetValue.PartiallyExpanded)) {
            boolean $i$a$-require-SheetState$42 = false;
            String $i$a$-require-SheetState$42 = "The initial value must not be set to PartiallyExpanded if skipPartiallyExpanded is set to true.";
            throw new IllegalArgumentException($i$a$-require-SheetState$42.toString());
        }
        if (this.skipHiddenState && !(initialValue != SheetValue.Hidden)) {
            boolean bl = false;
            String string = "The initial value must not be set to Hidden if skipHiddenState is set to true.";
            throw new IllegalArgumentException(string.toString());
        }
        AnimationSpec animationSpec = SheetDefaultsKt.access$getBottomSheetAnimationSpec$p();
        this.anchoredDraggableState = new AnchoredDraggableState<SheetValue>(initialValue, (Function1<? super Float, Float>)((Function1)arg_0 -> SheetState.anchoredDraggableState$lambda$6(density, arg_0)), (Function0<Float>)((Function0)() -> SheetState.anchoredDraggableState$lambda$8(density)), (AnimationSpec<Float>)animationSpec, confirmValueChange);
    }

    public /* synthetic */ SheetState(boolean bl, Density density, SheetValue sheetValue, Function1 function1, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            sheetValue = SheetValue.Hidden;
        }
        if ((n & 8) != 0) {
            function1 = SheetState::_init_$lambda$0;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(bl, density, sheetValue, (Function1<? super SheetValue, Boolean>)function1, bl2);
    }

    public final boolean getSkipPartiallyExpanded$material3() {
        return this.skipPartiallyExpanded;
    }

    public final boolean getSkipHiddenState$material3() {
        return this.skipHiddenState;
    }

    @NotNull
    public final SheetValue getCurrentValue() {
        return this.anchoredDraggableState.getCurrentValue();
    }

    @NotNull
    public final SheetValue getTargetValue() {
        return this.anchoredDraggableState.getTargetValue();
    }

    public final boolean isVisible() {
        return this.anchoredDraggableState.getCurrentValue() != SheetValue.Hidden;
    }

    public final float requireOffset() {
        return this.anchoredDraggableState.requireOffset();
    }

    public final boolean getHasExpandedState() {
        return this.anchoredDraggableState.getAnchors().hasAnchorFor(SheetValue.Expanded);
    }

    public final boolean getHasPartiallyExpandedState() {
        return this.anchoredDraggableState.getAnchors().hasAnchorFor(SheetValue.PartiallyExpanded);
    }

    @Nullable
    public final Object expand(@NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.animateTo$default(this.anchoredDraggableState, (Object)SheetValue.Expanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object partialExpand(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipPartiallyExpanded)) {
            boolean bl = false;
            String string = "Attempted to animate to partial expanded when skipPartiallyExpanded was enabled. Set skipPartiallyExpanded to false to use this function.";
            throw new IllegalStateException(string.toString());
        }
        Object object = SheetState.animateTo$material3$default(this, SheetValue.PartiallyExpanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object show(@NotNull Continuation<? super Unit> $completion) {
        SheetValue targetValue = this.getHasPartiallyExpandedState() ? SheetValue.PartiallyExpanded : SheetValue.Expanded;
        Object object = SheetState.animateTo$material3$default(this, targetValue, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object hide(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipHiddenState)) {
            boolean bl = false;
            String string = "Attempted to animate to hidden when skipHiddenState was enabled. Set skipHiddenState to false to use this function.";
            throw new IllegalStateException(string.toString());
        }
        Object object = SheetState.animateTo$material3$default(this, SheetValue.Hidden, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object animateTo$material3(@NotNull SheetValue targetValue, float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.animateTo(this.anchoredDraggableState, targetValue, velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object animateTo$material3$default(SheetState sheetState, SheetValue sheetValue, float f, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            f = sheetState.anchoredDraggableState.getLastVelocity();
        }
        return sheetState.animateTo$material3(sheetValue, f, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object snapTo$material3(@NotNull SheetValue targetValue, @NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.snapTo(this.anchoredDraggableState, targetValue, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object settle$material3(float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.anchoredDraggableState.settle(velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final AnchoredDraggableState<SheetValue> getAnchoredDraggableState$material3() {
        return this.anchoredDraggableState;
    }

    public final void setAnchoredDraggableState$material3(@NotNull AnchoredDraggableState<SheetValue> anchoredDraggableState) {
        Intrinsics.checkNotNullParameter(anchoredDraggableState, (String)"<set-?>");
        this.anchoredDraggableState = anchoredDraggableState;
    }

    @Nullable
    public final Float getOffset$material3() {
        return Float.valueOf(this.anchoredDraggableState.getOffset());
    }

    private static final boolean _init_$lambda$0(SheetValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return true;
    }

    private static final float anchoredDraggableState$lambda$6(Density $density, float it) {
        Density $this$anchoredDraggableState_u24lambda_u246_u24lambda_u245 = $density;
        boolean bl = false;
        int $this$dp$iv = 56;
        boolean $i$f$getDp = false;
        return $this$anchoredDraggableState_u24lambda_u246_u24lambda_u245.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv));
    }

    private static final float anchoredDraggableState$lambda$8(Density $density) {
        Density $this$anchoredDraggableState_u24lambda_u248_u24lambda_u247 = $density;
        boolean bl = false;
        int $this$dp$iv = 125;
        boolean $i$f$getDp = false;
        return $this$anchoredDraggableState_u24lambda_u248_u24lambda_u247.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Landroidx/compose/material3/SheetState$Companion;", "", "<init>", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/material3/SheetState;", "Landroidx/compose/material3/SheetValue;", "skipPartiallyExpanded", "", "confirmValueChange", "Lkotlin/Function1;", "density", "Landroidx/compose/ui/unit/Density;", "skipHiddenState", "material3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<SheetState, SheetValue> Saver(boolean skipPartiallyExpanded, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange, @NotNull Density density, boolean skipHiddenState) {
            Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            return SaverKt.Saver(Companion::Saver$lambda$0, arg_0 -> Companion.Saver$lambda$1(skipPartiallyExpanded, density, confirmValueChange, skipHiddenState, arg_0));
        }

        private static final SheetValue Saver$lambda$0(SaverScope $this$Saver, SheetState it) {
            Intrinsics.checkNotNullParameter((Object)$this$Saver, (String)"$this$Saver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getCurrentValue();
        }

        private static final SheetState Saver$lambda$1(boolean $skipPartiallyExpanded, Density $density, Function1 $confirmValueChange, boolean $skipHiddenState, SheetValue savedValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)savedValue), (String)"savedValue");
            return new SheetState($skipPartiallyExpanded, $density, savedValue, (Function1<? super SheetValue, Boolean>)$confirmValueChange, $skipHiddenState);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

