/*
 * Decompiled with CFR 0.152.
 */
package data.alarms.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.shambatimes.database.AlarmPerformanceLocal;
import common.TimeFormat;
import data.LocalMapper;
import extensions.InstantExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u001a\u001a\u00020\u00022\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001c\"\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J\t\u0010(\u001a\u00020\rH\u00c6\u0003JY\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010*\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0019\u00a8\u00061"}, d2={"Ldata/alarms/model/AlarmPerformance;", "Ldata/LocalMapper;", "Lcom/shambatimes/database/AlarmPerformanceLocal;", "performanceId", "", "artistName", "stageName", "stageColor", "alarmTimeInEpochMillis", "", "performanceTimeInEpochMillis", "zoneId", "isNotified", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;Z)V", "getPerformanceId", "()Ljava/lang/String;", "getArtistName", "getStageName", "getStageColor", "getAlarmTimeInEpochMillis", "()J", "getPerformanceTimeInEpochMillis", "getZoneId", "()Z", "mapToLocal", "param", "", "([Ljava/lang/String;)Lcom/shambatimes/database/AlarmPerformanceLocal;", "performanceDisplayTime", "timeFormat", "Lcommon/TimeFormat;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "shared"})
@StabilityInferred(parameters=1)
public final class AlarmPerformance
implements LocalMapper<AlarmPerformanceLocal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String performanceId;
    @NotNull
    private final String artistName;
    @NotNull
    private final String stageName;
    @NotNull
    private final String stageColor;
    private final long alarmTimeInEpochMillis;
    private final long performanceTimeInEpochMillis;
    @NotNull
    private final String zoneId;
    private final boolean isNotified;
    public static final int $stable;
    @NotNull
    public static final String extraKey = "alarmPerformanceExtra";

    public AlarmPerformance(@NotNull String performanceId, @NotNull String artistName, @NotNull String stageName, @NotNull String stageColor, long alarmTimeInEpochMillis, long performanceTimeInEpochMillis, @NotNull String zoneId, boolean isNotified) {
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)stageName, (String)"stageName");
        Intrinsics.checkNotNullParameter((Object)stageColor, (String)"stageColor");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.performanceId = performanceId;
        this.artistName = artistName;
        this.stageName = stageName;
        this.stageColor = stageColor;
        this.alarmTimeInEpochMillis = alarmTimeInEpochMillis;
        this.performanceTimeInEpochMillis = performanceTimeInEpochMillis;
        this.zoneId = zoneId;
        this.isNotified = isNotified;
    }

    public /* synthetic */ AlarmPerformance(String string2, String string3, String string4, String string5, long l, long l2, String string6, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            string4 = "";
        }
        if ((n & 8) != 0) {
            string5 = "";
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(string2, string3, string4, string5, l, l2, string6, bl);
    }

    @NotNull
    public final String getPerformanceId() {
        return this.performanceId;
    }

    @NotNull
    public final String getArtistName() {
        return this.artistName;
    }

    @NotNull
    public final String getStageName() {
        return this.stageName;
    }

    @NotNull
    public final String getStageColor() {
        return this.stageColor;
    }

    public final long getAlarmTimeInEpochMillis() {
        return this.alarmTimeInEpochMillis;
    }

    public final long getPerformanceTimeInEpochMillis() {
        return this.performanceTimeInEpochMillis;
    }

    @NotNull
    public final String getZoneId() {
        return this.zoneId;
    }

    public final boolean isNotified() {
        return this.isNotified;
    }

    @Override
    @NotNull
    public AlarmPerformanceLocal mapToLocal(String ... param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return new AlarmPerformanceLocal(this.performanceId, this.artistName, this.stageName, this.stageColor, this.alarmTimeInEpochMillis, this.performanceTimeInEpochMillis, this.zoneId, this.isNotified ? 0L : 1L);
    }

    @NotNull
    public final String performanceDisplayTime(@NotNull TimeFormat timeFormat) {
        Intrinsics.checkNotNullParameter((Object)timeFormat, (String)"timeFormat");
        return InstantExtensionsKt.toDisplayTime$default(Instant.Companion.fromEpochMilliseconds(this.performanceTimeInEpochMillis), timeFormat, TimeZone.Companion.of(this.zoneId), null, 4, null);
    }

    @NotNull
    public final String component1() {
        return this.performanceId;
    }

    @NotNull
    public final String component2() {
        return this.artistName;
    }

    @NotNull
    public final String component3() {
        return this.stageName;
    }

    @NotNull
    public final String component4() {
        return this.stageColor;
    }

    public final long component5() {
        return this.alarmTimeInEpochMillis;
    }

    public final long component6() {
        return this.performanceTimeInEpochMillis;
    }

    @NotNull
    public final String component7() {
        return this.zoneId;
    }

    public final boolean component8() {
        return this.isNotified;
    }

    @NotNull
    public final AlarmPerformance copy(@NotNull String performanceId, @NotNull String artistName, @NotNull String stageName, @NotNull String stageColor, long alarmTimeInEpochMillis, long performanceTimeInEpochMillis, @NotNull String zoneId, boolean isNotified) {
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)stageName, (String)"stageName");
        Intrinsics.checkNotNullParameter((Object)stageColor, (String)"stageColor");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return new AlarmPerformance(performanceId, artistName, stageName, stageColor, alarmTimeInEpochMillis, performanceTimeInEpochMillis, zoneId, isNotified);
    }

    public static /* synthetic */ AlarmPerformance copy$default(AlarmPerformance alarmPerformance, String string2, String string3, String string4, String string5, long l, long l2, String string6, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = alarmPerformance.performanceId;
        }
        if ((n & 2) != 0) {
            string3 = alarmPerformance.artistName;
        }
        if ((n & 4) != 0) {
            string4 = alarmPerformance.stageName;
        }
        if ((n & 8) != 0) {
            string5 = alarmPerformance.stageColor;
        }
        if ((n & 0x10) != 0) {
            l = alarmPerformance.alarmTimeInEpochMillis;
        }
        if ((n & 0x20) != 0) {
            l2 = alarmPerformance.performanceTimeInEpochMillis;
        }
        if ((n & 0x40) != 0) {
            string6 = alarmPerformance.zoneId;
        }
        if ((n & 0x80) != 0) {
            bl = alarmPerformance.isNotified;
        }
        return alarmPerformance.copy(string2, string3, string4, string5, l, l2, string6, bl);
    }

    @NotNull
    public String toString() {
        return "AlarmPerformance(performanceId=" + this.performanceId + ", artistName=" + this.artistName + ", stageName=" + this.stageName + ", stageColor=" + this.stageColor + ", alarmTimeInEpochMillis=" + this.alarmTimeInEpochMillis + ", performanceTimeInEpochMillis=" + this.performanceTimeInEpochMillis + ", zoneId=" + this.zoneId + ", isNotified=" + this.isNotified + ")";
    }

    public int hashCode() {
        int result = this.performanceId.hashCode();
        result = result * 31 + this.artistName.hashCode();
        result = result * 31 + this.stageName.hashCode();
        result = result * 31 + this.stageColor.hashCode();
        result = result * 31 + Long.hashCode(this.alarmTimeInEpochMillis);
        result = result * 31 + Long.hashCode(this.performanceTimeInEpochMillis);
        result = result * 31 + this.zoneId.hashCode();
        result = result * 31 + Boolean.hashCode(this.isNotified);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlarmPerformance)) {
            return false;
        }
        AlarmPerformance alarmPerformance = (AlarmPerformance)other;
        if (!Intrinsics.areEqual((Object)this.performanceId, (Object)alarmPerformance.performanceId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artistName, (Object)alarmPerformance.artistName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageName, (Object)alarmPerformance.stageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageColor, (Object)alarmPerformance.stageColor)) {
            return false;
        }
        if (this.alarmTimeInEpochMillis != alarmPerformance.alarmTimeInEpochMillis) {
            return false;
        }
        if (this.performanceTimeInEpochMillis != alarmPerformance.performanceTimeInEpochMillis) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.zoneId, (Object)alarmPerformance.zoneId)) {
            return false;
        }
        return this.isNotified == alarmPerformance.isNotified;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldata/alarms/model/AlarmPerformance$Companion;", "", "<init>", "()V", "extraKey", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

