/*
 * Decompiled with CFR 0.152.
 */
package data.messaging;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithoutReturn;
import com.russhwolf.settings.Settings;
import com.shambatimes.database.NotificationMessageLocal;
import com.shambatimes.database.NotificationMessageQueries;
import data.messaging.MessagingLocalApi;
import data.messaging.model.NotificationMessage;
import data.messaging.model.NotificationMessageKt;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldata/messaging/MessagingLocalSource;", "Ldata/messaging/MessagingLocalApi;", "notificationMessageDao", "Lcom/shambatimes/database/NotificationMessageQueries;", "settings", "Lcom/russhwolf/settings/Settings;", "logger", "Ldi/MultiLogger;", "<init>", "(Lcom/shambatimes/database/NotificationMessageQueries;Lcom/russhwolf/settings/Settings;Ldi/MultiLogger;)V", "addMessageList", "", "messageList", "", "Ldata/messaging/model/NotificationMessage;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addMessage", "message", "(Ldata/messaging/model/NotificationMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMessageList", "eventId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setLastMessageSeen", "lastMessage", "getLastMessageSeen", "Lkotlinx/datetime/LocalDateTime;", "lastMessageSettingsKey", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMessagingLocalSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagingLocalSource.kt\ndata/messaging/MessagingLocalSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1563#2:78\n1634#2,3:79\n1068#2:82\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 MessagingLocalSource.kt\ndata/messaging/MessagingLocalSource\n*L\n43#1:78\n43#1:79,3\n45#1:82\n20#1:83,2\n*E\n"})
public final class MessagingLocalSource
implements MessagingLocalApi {
    @NotNull
    private final NotificationMessageQueries notificationMessageDao;
    @NotNull
    private final Settings settings;
    @NotNull
    private final MultiLogger logger;
    public static final int $stable = 8;

    public MessagingLocalSource(@NotNull NotificationMessageQueries notificationMessageDao, @NotNull Settings settings, @NotNull MultiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationMessageDao), (String)"notificationMessageDao");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.notificationMessageDao = notificationMessageDao;
        this.settings = settings;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Object addMessageList(@NotNull List<NotificationMessage> messageList, @NotNull Continuation<? super Unit> $completion) {
        try {
            Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)this.notificationMessageDao), (boolean)false, arg_0 -> MessagingLocalSource.addMessageList$lambda$1(messageList, this, arg_0), (int)1, null);
        }
        catch (Exception exception) {
            this.logger.e("addMessageList Failure", exception);
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object addMessage(@NotNull NotificationMessage message, @NotNull Continuation<? super Unit> $completion) {
        try {
            Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)this.notificationMessageDao), (boolean)false, arg_0 -> MessagingLocalSource.addMessage$lambda$2(this, message, arg_0), (int)1, null);
        }
        catch (Exception exception) {
            this.logger.e("addMessage Failure", exception);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getMessageList(@NotNull String eventId, @NotNull Continuation<? super List<NotificationMessage>> $completion) {
        List list;
        try {
            void $this$sortedByDescending$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = this.notificationMessageDao.selectAllForEvent(eventId).executeAsList();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NotificationMessageLocal notificationMessageLocal = (NotificationMessageLocal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(NotificationMessageKt.toDomain((NotificationMessageLocal)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            List result = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    NotificationMessage it = (NotificationMessage)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getTimeSent();
                    it = (NotificationMessage)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTimeSent()));
                }
            });
        }
        catch (Exception exception) {
            this.logger.e("getMessageList Failure", exception);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Object setLastMessageSeen(@NotNull NotificationMessage lastMessage, @NotNull Continuation<? super Unit> $completion) {
        this.settings.putString(this.lastMessageSettingsKey(lastMessage.getEventId()), lastMessage.getTimeSent().toString());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLastMessageSeen(@NotNull String eventId, @NotNull Continuation<? super LocalDateTime> $completion) {
        String result = this.settings.getStringOrNull(this.lastMessageSettingsKey(eventId));
        return result == null ? new LocalDateTime(new LocalDate(1900, 1, 1), new LocalTime(0, 0, 0, 0)) : LocalDateTime.Companion.parse$default((LocalDateTime.Companion)LocalDateTime.Companion, (CharSequence)result, null, (int)2, null);
    }

    private final String lastMessageSettingsKey(String eventId) {
        return "lastMessage" + eventId;
    }

    private static final Unit addMessageList$lambda$1(List $messageList, MessagingLocalSource this$0, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Iterable $this$forEach$iv = $messageList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationMessage message = (NotificationMessage)element$iv;
            boolean bl = false;
            this$0.notificationMessageDao.insert(message.mapToLocal(new String[0]));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMessage$lambda$2(MessagingLocalSource this$0, NotificationMessage $message, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        this$0.notificationMessageDao.insert($message.mapToLocal(new String[0]));
        return Unit.INSTANCE;
    }
}

