/*
 * Decompiled with CFR 0.152.
 */
package data.myevents;

import androidx.compose.runtime.internal.StabilityInferred;
import com.russhwolf.settings.Settings;
import com.shambatimes.database.MyEventsLocal;
import com.shambatimes.database.MyEventsQueries;
import data.account.ResultOf;
import data.myevents.MyEventLocalApi;
import data.myevents.model.MyEvent;
import data.myevents.model.MyEventKt;
import data.publishedevents.models.PublishedEvent;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldata/myevents/MyEventLocalSource;", "Ldata/myevents/MyEventLocalApi;", "dao", "Lcom/shambatimes/database/MyEventsQueries;", "logger", "Ldi/MultiLogger;", "settings", "Lcom/russhwolf/settings/Settings;", "<init>", "(Lcom/shambatimes/database/MyEventsQueries;Ldi/MultiLogger;Lcom/russhwolf/settings/Settings;)V", "addToMyEvents", "Ldata/account/ResultOf;", "", "publishedEvent", "Ldata/publishedevents/models/PublishedEvent;", "(Ldata/publishedevents/models/PublishedEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMyEventList", "", "Ldata/myevents/model/MyEvent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeEvent", "event", "(Ldata/myevents/model/MyEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setActiveEvent", "eventId", "", "accountId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMyEventLocalSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyEventLocalSource.kt\ndata/myevents/MyEventLocalSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1563#2:68\n1634#2,3:69\n*S KotlinDebug\n*F\n+ 1 MyEventLocalSource.kt\ndata/myevents/MyEventLocalSource\n*L\n40#1:68\n40#1:69,3\n*E\n"})
public final class MyEventLocalSource
implements MyEventLocalApi {
    @NotNull
    private final MyEventsQueries dao;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final Settings settings;
    public static final int $stable = 8;

    public MyEventLocalSource(@NotNull MyEventsQueries dao, @NotNull MultiLogger logger, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)dao), (String)"dao");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.dao = dao;
        this.logger = logger;
        this.settings = settings;
    }

    @Override
    @Nullable
    public Object addToMyEvents(@NotNull PublishedEvent publishedEvent, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        ResultOf resultOf;
        try {
            this.dao.insert(publishedEvent.getEventId(), publishedEvent.getAccountId(), publishedEvent.getAccountName(), publishedEvent.getStartDate().toString(), publishedEvent.getEndDate().toString(), publishedEvent.getImageUrl(), publishedEvent.getBannerUrl());
            resultOf = new ResultOf.Success<Unit>(Unit.INSTANCE);
        }
        catch (Exception exception) {
            this.logger.e("addToMyEvents", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getMyEventList(@NotNull Continuation<? super ResultOf<? extends List<MyEvent>>> $completion) {
        ResultOf resultOf;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.dao.selectAll().executeAsList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MyEventsLocal myEventsLocal = (MyEventsLocal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MyEventKt.mapToDomain((MyEventsLocal)it));
            }
            List result = (List)destination$iv$iv;
            resultOf = new ResultOf.Success<List>(result);
        }
        catch (Exception exception) {
            this.logger.e("getMyEventList", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    @Override
    @Nullable
    public Object removeEvent(@NotNull MyEvent event, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        ResultOf resultOf;
        try {
            this.dao.delete(event.getEventId());
            resultOf = new ResultOf.Success<Unit>(Unit.INSTANCE);
        }
        catch (Exception exception) {
            this.logger.e("removeEvent", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    @Override
    @Nullable
    public Object setActiveEvent(@NotNull String eventId, @NotNull String accountId, @NotNull Continuation<? super Unit> $completion) {
        this.logger.i("Active Event Set " + eventId + ". Account: " + accountId);
        this.settings.putString("activeEventSelectedKey", eventId);
        this.settings.putString("activeAccount", accountId);
        return Unit.INSTANCE;
    }
}

