/*
 * Decompiled with CFR 0.152.
 */
package models;

import androidx.compose.runtime.Stable;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.StringKt;
import com.github.ajalt.colormath.extensions.android.composecolor.ComposeColorExtensionsKt;
import com.github.ajalt.colormath.model.RGB;
import com.russhwolf.settings.Settings;
import common.TimeFormat;
import common.TimeProvider;
import common.states.FavoriteState;
import data.account.model.Stage;
import data.account.model.TagColor;
import data.account.model.YearData;
import data.alarms.model.AlarmPerformance;
import data.artist.model.Artist;
import data.artist.model.FavoritePerformance;
import data.artist.model.Performance;
import extensions.InstantExtensionsKt;
import extensions.LocalDateTimeExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import models.DisplayPerformanceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.elements.artist.AlarmState;
import ui.elements.artist.SeenState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b,\b\u0087\b\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B\u00ad\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0003\u0012\u0006\u0010\u0019\u001a\u00020\u0003\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001d\u001a\u00020\u0003\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000%\u0012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030%\u0012\u0006\u0010,\u001a\u00020\u000b\u0012\u0006\u0010-\u001a\u00020)\u0012\b\b\u0002\u0010.\u001a\u00020)\u00a2\u0006\u0004\b/\u00100J\u0006\u0010]\u001a\u00020)J \u0010^\u001a\u00020)2\u0006\u0010_\u001a\u00020\u001b2\u0006\u0010`\u001a\u00020\u001b2\b\b\u0002\u0010a\u001a\u00020\u000bJ\u0016\u0010b\u001a\u00020)2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fJ\u000e\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020jJ\t\u0010k\u001a\u00020\u0003H\u00c6\u0003J\t\u0010l\u001a\u00020\u0003H\u00c6\u0003J\t\u0010m\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\t\u0010o\u001a\u00020\u0003H\u00c6\u0003J\t\u0010p\u001a\u00020\u0003H\u00c6\u0003J\t\u0010q\u001a\u00020\u000bH\u00c6\u0003J\t\u0010r\u001a\u00020\u000bH\u00c6\u0003J\t\u0010s\u001a\u00020\u0003H\u00c6\u0003J\t\u0010t\u001a\u00020\u000bH\u00c6\u0003J\t\u0010u\u001a\u00020\u0003H\u00c6\u0003J\t\u0010v\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010w\u001a\u00020\u0012H\u00c6\u0003\u00a2\u0006\u0004\bx\u0010AJ\u000b\u0010y\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010z\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0002\b{J\t\u0010|\u001a\u00020\u0016H\u00c6\u0003J\t\u0010}\u001a\u00020\u0016H\u00c6\u0003J\t\u0010~\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u007f\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u0080\u0001\u001a\u00020\u001bH\u00c6\u0003J\n\u0010\u0081\u0001\u001a\u00020\u001bH\u00c6\u0003J\n\u0010\u0082\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u0083\u0001\u001a\u00020\u001fH\u00c6\u0003J\n\u0010\u0084\u0001\u001a\u00020!H\u00c6\u0003J\n\u0010\u0085\u0001\u001a\u00020#H\u00c6\u0003J\u0010\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u00c6\u0003J\n\u0010\u0087\u0001\u001a\u00020'H\u00c6\u0003J\n\u0010\u0088\u0001\u001a\u00020)H\u00c6\u0003J\u0010\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000%H\u00c6\u0003J\u0010\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u00c6\u0003J\n\u0010\u008b\u0001\u001a\u00020\u000bH\u00c6\u0003J\n\u0010\u008c\u0001\u001a\u00020)H\u00c6\u0003J\n\u0010\u008d\u0001\u001a\u00020)H\u00c6\u0003J\u00f9\u0002\u0010\u008e\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000%2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030%2\b\b\u0002\u0010,\u001a\u00020\u000b2\b\b\u0002\u0010-\u001a\u00020)2\b\b\u0002\u0010.\u001a\u00020)H\u00c6\u0001\u00a2\u0006\u0006\b\u008f\u0001\u0010\u0090\u0001J\u0015\u0010\u0091\u0001\u001a\u00020)2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010\u0093\u0001\u001a\u00020\u000bH\u00d6\u0001J\n\u0010\u0094\u0001\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00102R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00102R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00102R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00102R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010:R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00102R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010:R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00102R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00102R\u0013\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\n\n\u0002\u0010B\u001a\u0004\b@\u0010AR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00102R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010GR\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u00102R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00102R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010LR\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u00102R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010YR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000%\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010VR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030%\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010VR\u0011\u0010,\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010:R\u0011\u0010-\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010YR\u0011\u0010.\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010Y\u00a8\u0006\u0096\u0001"}, d2={"Lmodels/DisplayPerformance;", "", "artistId", "", "performanceId", "artistName", "gridSplitName", "Lkotlinx/collections/immutable/ImmutableList;", "artistDescription", "artistImageUrl", "imageWidth", "", "imageHeight", "stageKey", "stageIndex", "stageName", "stageColor", "stageComposeColor", "Landroidx/compose/ui/graphics/Color;", "tagColor", "tagComposeColor", "startTime", "Lkotlinx/datetime/LocalDateTime;", "endTime", "startTimeString", "endTimeString", "startInstant", "Lkotlinx/datetime/Instant;", "endInstant", "dayOfWeek", "favoriteState", "Lcommon/states/FavoriteState;", "alarmState", "Lui/elements/artist/AlarmState;", "seenState", "Lui/elements/artist/SeenState;", "genreList", "", "zoneId", "Lkotlinx/datetime/TimeZone;", "isDeleted", "", "conflicts", "socialList", "version", "isLastChangeNotifiable", "isNewForChangeDialog", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/collections/immutable/ImmutableList;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;ILjava/lang/String;Ljava/lang/String;JLjava/lang/String;Landroidx/compose/ui/graphics/Color;Lkotlinx/datetime/LocalDateTime;Lkotlinx/datetime/LocalDateTime;Ljava/lang/String;Ljava/lang/String;Lkotlinx/datetime/Instant;Lkotlinx/datetime/Instant;Ljava/lang/String;Lcommon/states/FavoriteState;Lui/elements/artist/AlarmState;Lui/elements/artist/SeenState;Ljava/util/List;Lkotlinx/datetime/TimeZone;ZLjava/util/List;Ljava/util/List;IZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getArtistId", "()Ljava/lang/String;", "getPerformanceId", "getArtistName", "getGridSplitName", "()Lkotlinx/collections/immutable/ImmutableList;", "getArtistDescription", "getArtistImageUrl", "getImageWidth", "()I", "getImageHeight", "getStageKey", "getStageIndex", "getStageName", "getStageColor", "getStageComposeColor-0d7_KjU", "()J", "J", "getTagColor", "getTagComposeColor-QN2ZGVo", "()Landroidx/compose/ui/graphics/Color;", "getStartTime", "()Lkotlinx/datetime/LocalDateTime;", "getEndTime", "getStartTimeString", "getEndTimeString", "getStartInstant", "()Lkotlinx/datetime/Instant;", "getEndInstant", "getDayOfWeek", "getFavoriteState", "()Lcommon/states/FavoriteState;", "getAlarmState", "()Lui/elements/artist/AlarmState;", "getSeenState", "()Lui/elements/artist/SeenState;", "getGenreList", "()Ljava/util/List;", "getZoneId", "()Lkotlinx/datetime/TimeZone;", "()Z", "getConflicts", "getSocialList", "getVersion", "hasProfile", "isBetweenStartAndEndWindow", "windowStart", "windowEnd", "windowThreshold", "isBeforeAlarmCutoff", "settings", "Lcom/russhwolf/settings/Settings;", "timeProvider", "Lcommon/TimeProvider;", "mapToAlarm", "Ldata/alarms/model/AlarmPerformance;", "minuteOffset", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component13-0d7_KjU", "component14", "component15", "component15-QN2ZGVo", "component16", "component17", "component18", "component19", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component30", "component31", "component32", "component33", "copy", "copy-rS6ku68", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/collections/immutable/ImmutableList;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;ILjava/lang/String;Ljava/lang/String;JLjava/lang/String;Landroidx/compose/ui/graphics/Color;Lkotlinx/datetime/LocalDateTime;Lkotlinx/datetime/LocalDateTime;Ljava/lang/String;Ljava/lang/String;Lkotlinx/datetime/Instant;Lkotlinx/datetime/Instant;Ljava/lang/String;Lcommon/states/FavoriteState;Lui/elements/artist/AlarmState;Lui/elements/artist/SeenState;Ljava/util/List;Lkotlinx/datetime/TimeZone;ZLjava/util/List;Ljava/util/List;IZZ)Lmodels/DisplayPerformance;", "equals", "other", "hashCode", "toString", "Companion", "shared"})
@Stable
public final class DisplayPerformance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String artistId;
    @NotNull
    private final String performanceId;
    @NotNull
    private final String artistName;
    @NotNull
    private final ImmutableList<String> gridSplitName;
    @NotNull
    private final String artistDescription;
    @NotNull
    private final String artistImageUrl;
    private final int imageWidth;
    private final int imageHeight;
    @NotNull
    private final String stageKey;
    private final int stageIndex;
    @NotNull
    private final String stageName;
    @NotNull
    private final String stageColor;
    private final long stageComposeColor;
    @Nullable
    private final String tagColor;
    @Nullable
    private final Color tagComposeColor;
    @NotNull
    private final LocalDateTime startTime;
    @NotNull
    private final LocalDateTime endTime;
    @NotNull
    private final String startTimeString;
    @NotNull
    private final String endTimeString;
    @NotNull
    private final Instant startInstant;
    @NotNull
    private final Instant endInstant;
    @NotNull
    private final String dayOfWeek;
    @NotNull
    private final FavoriteState favoriteState;
    @NotNull
    private final AlarmState alarmState;
    @NotNull
    private final SeenState seenState;
    @NotNull
    private final List<String> genreList;
    @NotNull
    private final TimeZone zoneId;
    private final boolean isDeleted;
    @NotNull
    private final List<DisplayPerformance> conflicts;
    @NotNull
    private final List<String> socialList;
    private final int version;
    private final boolean isLastChangeNotifiable;
    private final boolean isNewForChangeDialog;
    public static final int $stable;

    private DisplayPerformance(String artistId, String performanceId, String artistName, ImmutableList<String> gridSplitName, String artistDescription, String artistImageUrl, int imageWidth, int imageHeight, String stageKey, int stageIndex, String stageName, String stageColor, long stageComposeColor, String tagColor, Color tagComposeColor, LocalDateTime startTime, LocalDateTime endTime, String startTimeString, String endTimeString, Instant startInstant, Instant endInstant, String dayOfWeek, FavoriteState favoriteState, AlarmState alarmState, SeenState seenState, List<String> genreList, TimeZone zoneId, boolean isDeleted, List<DisplayPerformance> conflicts, List<String> socialList, int version, boolean isLastChangeNotifiable, boolean isNewForChangeDialog) {
        Intrinsics.checkNotNullParameter((Object)artistId, (String)"artistId");
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter(gridSplitName, (String)"gridSplitName");
        Intrinsics.checkNotNullParameter((Object)artistDescription, (String)"artistDescription");
        Intrinsics.checkNotNullParameter((Object)artistImageUrl, (String)"artistImageUrl");
        Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
        Intrinsics.checkNotNullParameter((Object)stageName, (String)"stageName");
        Intrinsics.checkNotNullParameter((Object)stageColor, (String)"stageColor");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)startTimeString, (String)"startTimeString");
        Intrinsics.checkNotNullParameter((Object)endTimeString, (String)"endTimeString");
        Intrinsics.checkNotNullParameter((Object)startInstant, (String)"startInstant");
        Intrinsics.checkNotNullParameter((Object)endInstant, (String)"endInstant");
        Intrinsics.checkNotNullParameter((Object)dayOfWeek, (String)"dayOfWeek");
        Intrinsics.checkNotNullParameter((Object)favoriteState, (String)"favoriteState");
        Intrinsics.checkNotNullParameter((Object)alarmState, (String)"alarmState");
        Intrinsics.checkNotNullParameter((Object)seenState, (String)"seenState");
        Intrinsics.checkNotNullParameter(genreList, (String)"genreList");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter(socialList, (String)"socialList");
        this.artistId = artistId;
        this.performanceId = performanceId;
        this.artistName = artistName;
        this.gridSplitName = gridSplitName;
        this.artistDescription = artistDescription;
        this.artistImageUrl = artistImageUrl;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.stageKey = stageKey;
        this.stageIndex = stageIndex;
        this.stageName = stageName;
        this.stageColor = stageColor;
        this.stageComposeColor = stageComposeColor;
        this.tagColor = tagColor;
        this.tagComposeColor = tagComposeColor;
        this.startTime = startTime;
        this.endTime = endTime;
        this.startTimeString = startTimeString;
        this.endTimeString = endTimeString;
        this.startInstant = startInstant;
        this.endInstant = endInstant;
        this.dayOfWeek = dayOfWeek;
        this.favoriteState = favoriteState;
        this.alarmState = alarmState;
        this.seenState = seenState;
        this.genreList = genreList;
        this.zoneId = zoneId;
        this.isDeleted = isDeleted;
        this.conflicts = conflicts;
        this.socialList = socialList;
        this.version = version;
        this.isLastChangeNotifiable = isLastChangeNotifiable;
        this.isNewForChangeDialog = isNewForChangeDialog;
    }

    public /* synthetic */ DisplayPerformance(String string2, String string3, String string4, ImmutableList immutableList, String string5, String string6, int n, int n2, String string7, int n3, String string8, String string9, long l, String string10, Color color, LocalDateTime localDateTime, LocalDateTime localDateTime2, String string11, String string12, Instant instant, Instant instant2, String string13, FavoriteState favoriteState, AlarmState alarmState, SeenState seenState, List list, TimeZone timeZone, boolean bl, List list2, List list3, int n4, boolean bl2, boolean bl3, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            bl3 = false;
        }
        this(string2, string3, string4, immutableList, string5, string6, n, n2, string7, n3, string8, string9, l, string10, color, localDateTime, localDateTime2, string11, string12, instant, instant2, string13, favoriteState, alarmState, seenState, list, timeZone, bl, list2, list3, n4, bl2, bl3, null);
    }

    @NotNull
    public final String getArtistId() {
        return this.artistId;
    }

    @NotNull
    public final String getPerformanceId() {
        return this.performanceId;
    }

    @NotNull
    public final String getArtistName() {
        return this.artistName;
    }

    @NotNull
    public final ImmutableList<String> getGridSplitName() {
        return this.gridSplitName;
    }

    @NotNull
    public final String getArtistDescription() {
        return this.artistDescription;
    }

    @NotNull
    public final String getArtistImageUrl() {
        return this.artistImageUrl;
    }

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    @NotNull
    public final String getStageKey() {
        return this.stageKey;
    }

    public final int getStageIndex() {
        return this.stageIndex;
    }

    @NotNull
    public final String getStageName() {
        return this.stageName;
    }

    @NotNull
    public final String getStageColor() {
        return this.stageColor;
    }

    public final long getStageComposeColor-0d7_KjU() {
        return this.stageComposeColor;
    }

    @Nullable
    public final String getTagColor() {
        return this.tagColor;
    }

    @Nullable
    public final Color getTagComposeColor-QN2ZGVo() {
        return this.tagComposeColor;
    }

    @NotNull
    public final LocalDateTime getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final LocalDateTime getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final String getStartTimeString() {
        return this.startTimeString;
    }

    @NotNull
    public final String getEndTimeString() {
        return this.endTimeString;
    }

    @NotNull
    public final Instant getStartInstant() {
        return this.startInstant;
    }

    @NotNull
    public final Instant getEndInstant() {
        return this.endInstant;
    }

    @NotNull
    public final String getDayOfWeek() {
        return this.dayOfWeek;
    }

    @NotNull
    public final FavoriteState getFavoriteState() {
        return this.favoriteState;
    }

    @NotNull
    public final AlarmState getAlarmState() {
        return this.alarmState;
    }

    @NotNull
    public final SeenState getSeenState() {
        return this.seenState;
    }

    @NotNull
    public final List<String> getGenreList() {
        return this.genreList;
    }

    @NotNull
    public final TimeZone getZoneId() {
        return this.zoneId;
    }

    public final boolean isDeleted() {
        return this.isDeleted;
    }

    @NotNull
    public final List<DisplayPerformance> getConflicts() {
        return this.conflicts;
    }

    @NotNull
    public final List<String> getSocialList() {
        return this.socialList;
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean isLastChangeNotifiable() {
        return this.isLastChangeNotifiable;
    }

    public final boolean isNewForChangeDialog() {
        return this.isNewForChangeDialog;
    }

    public final boolean hasProfile() {
        return ((CharSequence)this.artistImageUrl).length() > 0 ? true : (((CharSequence)this.artistDescription).length() > 0 ? true : !((Collection)this.socialList).isEmpty());
    }

    public final boolean isBetweenStartAndEndWindow(@NotNull Instant windowStart, @NotNull Instant windowEnd, int windowThreshold) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)windowStart, (String)"windowStart");
        Intrinsics.checkNotNullParameter((Object)windowEnd, (String)"windowEnd");
        if (Intrinsics.areEqual((Object)windowStart, (Object)this.startInstant) || windowStart.compareTo(this.startInstant) > 0) {
            long minutesBetweenEndWindowAndEnd = Duration.getInWholeMinutes-impl((long)this.endInstant.minus-5sfh64U(windowEnd));
            bl = Intrinsics.areEqual((Object)windowEnd, (Object)this.endInstant) || windowEnd.compareTo(this.endInstant) < 0 ? true : minutesBetweenEndWindowAndEnd > (long)(-windowThreshold);
        } else {
            long minutesBetweenStartAndWindowEnd = Duration.getInWholeMinutes-impl((long)this.startInstant.minus-5sfh64U(windowStart));
            bl = minutesBetweenStartAndWindowEnd < (long)windowThreshold;
        }
        return bl;
    }

    public static /* synthetic */ boolean isBetweenStartAndEndWindow$default(DisplayPerformance displayPerformance, Instant instant, Instant instant2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 30;
        }
        return displayPerformance.isBetweenStartAndEndWindow(instant, instant2, n);
    }

    public final boolean isBeforeAlarmCutoff(@NotNull Settings settings, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        long timeOffset = settings.getInt("alarmOffsetKey", 30);
        return InstantJvmKt.plus((Instant)timeProvider.getNowInstant(this.zoneId), (long)timeOffset, (DateTimeUnit.TimeBased)DateTimeUnit.Companion.getMINUTE()).compareTo(this.startInstant) <= 0;
    }

    @NotNull
    public final AlarmPerformance mapToAlarm(long minuteOffset) {
        return new AlarmPerformance(this.performanceId, this.artistName, this.stageName, this.stageColor, InstantKt.minus((Instant)InstantExtensionsKt.toUtcInstantAt(this.startInstant, this.zoneId), (long)minuteOffset, (DateTimeUnit.TimeBased)DateTimeUnit.Companion.getMINUTE()).toEpochMilliseconds(), InstantExtensionsKt.toUtcInstantAt(this.startInstant, this.zoneId).toEpochMilliseconds(), this.zoneId.toString(), false, 128, null);
    }

    @NotNull
    public final String component1() {
        return this.artistId;
    }

    @NotNull
    public final String component2() {
        return this.performanceId;
    }

    @NotNull
    public final String component3() {
        return this.artistName;
    }

    @NotNull
    public final ImmutableList<String> component4() {
        return this.gridSplitName;
    }

    @NotNull
    public final String component5() {
        return this.artistDescription;
    }

    @NotNull
    public final String component6() {
        return this.artistImageUrl;
    }

    public final int component7() {
        return this.imageWidth;
    }

    public final int component8() {
        return this.imageHeight;
    }

    @NotNull
    public final String component9() {
        return this.stageKey;
    }

    public final int component10() {
        return this.stageIndex;
    }

    @NotNull
    public final String component11() {
        return this.stageName;
    }

    @NotNull
    public final String component12() {
        return this.stageColor;
    }

    public final long component13-0d7_KjU() {
        return this.stageComposeColor;
    }

    @Nullable
    public final String component14() {
        return this.tagColor;
    }

    @Nullable
    public final Color component15-QN2ZGVo() {
        return this.tagComposeColor;
    }

    @NotNull
    public final LocalDateTime component16() {
        return this.startTime;
    }

    @NotNull
    public final LocalDateTime component17() {
        return this.endTime;
    }

    @NotNull
    public final String component18() {
        return this.startTimeString;
    }

    @NotNull
    public final String component19() {
        return this.endTimeString;
    }

    @NotNull
    public final Instant component20() {
        return this.startInstant;
    }

    @NotNull
    public final Instant component21() {
        return this.endInstant;
    }

    @NotNull
    public final String component22() {
        return this.dayOfWeek;
    }

    @NotNull
    public final FavoriteState component23() {
        return this.favoriteState;
    }

    @NotNull
    public final AlarmState component24() {
        return this.alarmState;
    }

    @NotNull
    public final SeenState component25() {
        return this.seenState;
    }

    @NotNull
    public final List<String> component26() {
        return this.genreList;
    }

    @NotNull
    public final TimeZone component27() {
        return this.zoneId;
    }

    public final boolean component28() {
        return this.isDeleted;
    }

    @NotNull
    public final List<DisplayPerformance> component29() {
        return this.conflicts;
    }

    @NotNull
    public final List<String> component30() {
        return this.socialList;
    }

    public final int component31() {
        return this.version;
    }

    public final boolean component32() {
        return this.isLastChangeNotifiable;
    }

    public final boolean component33() {
        return this.isNewForChangeDialog;
    }

    @NotNull
    public final DisplayPerformance copy-rS6ku68(@NotNull String artistId, @NotNull String performanceId, @NotNull String artistName, @NotNull ImmutableList<String> gridSplitName, @NotNull String artistDescription, @NotNull String artistImageUrl, int imageWidth, int imageHeight, @NotNull String stageKey, int stageIndex, @NotNull String stageName, @NotNull String stageColor, long stageComposeColor, @Nullable String tagColor, @Nullable Color tagComposeColor, @NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull String startTimeString, @NotNull String endTimeString, @NotNull Instant startInstant, @NotNull Instant endInstant, @NotNull String dayOfWeek, @NotNull FavoriteState favoriteState, @NotNull AlarmState alarmState, @NotNull SeenState seenState, @NotNull List<String> genreList, @NotNull TimeZone zoneId, boolean isDeleted, @NotNull List<DisplayPerformance> conflicts, @NotNull List<String> socialList, int version, boolean isLastChangeNotifiable, boolean isNewForChangeDialog) {
        Intrinsics.checkNotNullParameter((Object)artistId, (String)"artistId");
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter(gridSplitName, (String)"gridSplitName");
        Intrinsics.checkNotNullParameter((Object)artistDescription, (String)"artistDescription");
        Intrinsics.checkNotNullParameter((Object)artistImageUrl, (String)"artistImageUrl");
        Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
        Intrinsics.checkNotNullParameter((Object)stageName, (String)"stageName");
        Intrinsics.checkNotNullParameter((Object)stageColor, (String)"stageColor");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)startTimeString, (String)"startTimeString");
        Intrinsics.checkNotNullParameter((Object)endTimeString, (String)"endTimeString");
        Intrinsics.checkNotNullParameter((Object)startInstant, (String)"startInstant");
        Intrinsics.checkNotNullParameter((Object)endInstant, (String)"endInstant");
        Intrinsics.checkNotNullParameter((Object)dayOfWeek, (String)"dayOfWeek");
        Intrinsics.checkNotNullParameter((Object)favoriteState, (String)"favoriteState");
        Intrinsics.checkNotNullParameter((Object)alarmState, (String)"alarmState");
        Intrinsics.checkNotNullParameter((Object)seenState, (String)"seenState");
        Intrinsics.checkNotNullParameter(genreList, (String)"genreList");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter(socialList, (String)"socialList");
        return new DisplayPerformance(artistId, performanceId, artistName, gridSplitName, artistDescription, artistImageUrl, imageWidth, imageHeight, stageKey, stageIndex, stageName, stageColor, stageComposeColor, tagColor, tagComposeColor, startTime, endTime, startTimeString, endTimeString, startInstant, endInstant, dayOfWeek, favoriteState, alarmState, seenState, genreList, zoneId, isDeleted, conflicts, socialList, version, isLastChangeNotifiable, isNewForChangeDialog, null);
    }

    public static /* synthetic */ DisplayPerformance copy-rS6ku68$default(DisplayPerformance displayPerformance, String string2, String string3, String string4, ImmutableList immutableList, String string5, String string6, int n, int n2, String string7, int n3, String string8, String string9, long l, String string10, Color color, LocalDateTime localDateTime, LocalDateTime localDateTime2, String string11, String string12, Instant instant, Instant instant2, String string13, FavoriteState favoriteState, AlarmState alarmState, SeenState seenState, List list, TimeZone timeZone, boolean bl, List list2, List list3, int n4, boolean bl2, boolean bl3, int n5, int n6, Object object) {
        if ((n5 & 1) != 0) {
            string2 = displayPerformance.artistId;
        }
        if ((n5 & 2) != 0) {
            string3 = displayPerformance.performanceId;
        }
        if ((n5 & 4) != 0) {
            string4 = displayPerformance.artistName;
        }
        if ((n5 & 8) != 0) {
            immutableList = displayPerformance.gridSplitName;
        }
        if ((n5 & 0x10) != 0) {
            string5 = displayPerformance.artistDescription;
        }
        if ((n5 & 0x20) != 0) {
            string6 = displayPerformance.artistImageUrl;
        }
        if ((n5 & 0x40) != 0) {
            n = displayPerformance.imageWidth;
        }
        if ((n5 & 0x80) != 0) {
            n2 = displayPerformance.imageHeight;
        }
        if ((n5 & 0x100) != 0) {
            string7 = displayPerformance.stageKey;
        }
        if ((n5 & 0x200) != 0) {
            n3 = displayPerformance.stageIndex;
        }
        if ((n5 & 0x400) != 0) {
            string8 = displayPerformance.stageName;
        }
        if ((n5 & 0x800) != 0) {
            string9 = displayPerformance.stageColor;
        }
        if ((n5 & 0x1000) != 0) {
            l = displayPerformance.stageComposeColor;
        }
        if ((n5 & 0x2000) != 0) {
            string10 = displayPerformance.tagColor;
        }
        if ((n5 & 0x4000) != 0) {
            color = displayPerformance.tagComposeColor;
        }
        if ((n5 & 0x8000) != 0) {
            localDateTime = displayPerformance.startTime;
        }
        if ((n5 & 0x10000) != 0) {
            localDateTime2 = displayPerformance.endTime;
        }
        if ((n5 & 0x20000) != 0) {
            string11 = displayPerformance.startTimeString;
        }
        if ((n5 & 0x40000) != 0) {
            string12 = displayPerformance.endTimeString;
        }
        if ((n5 & 0x80000) != 0) {
            instant = displayPerformance.startInstant;
        }
        if ((n5 & 0x100000) != 0) {
            instant2 = displayPerformance.endInstant;
        }
        if ((n5 & 0x200000) != 0) {
            string13 = displayPerformance.dayOfWeek;
        }
        if ((n5 & 0x400000) != 0) {
            favoriteState = displayPerformance.favoriteState;
        }
        if ((n5 & 0x800000) != 0) {
            alarmState = displayPerformance.alarmState;
        }
        if ((n5 & 0x1000000) != 0) {
            seenState = displayPerformance.seenState;
        }
        if ((n5 & 0x2000000) != 0) {
            list = displayPerformance.genreList;
        }
        if ((n5 & 0x4000000) != 0) {
            timeZone = displayPerformance.zoneId;
        }
        if ((n5 & 0x8000000) != 0) {
            bl = displayPerformance.isDeleted;
        }
        if ((n5 & 0x10000000) != 0) {
            list2 = displayPerformance.conflicts;
        }
        if ((n5 & 0x20000000) != 0) {
            list3 = displayPerformance.socialList;
        }
        if ((n5 & 0x40000000) != 0) {
            n4 = displayPerformance.version;
        }
        if ((n5 & Integer.MIN_VALUE) != 0) {
            bl2 = displayPerformance.isLastChangeNotifiable;
        }
        if ((n6 & 1) != 0) {
            bl3 = displayPerformance.isNewForChangeDialog;
        }
        return displayPerformance.copy-rS6ku68(string2, string3, string4, immutableList, string5, string6, n, n2, string7, n3, string8, string9, l, string10, color, localDateTime, localDateTime2, string11, string12, instant, instant2, string13, favoriteState, alarmState, seenState, list, timeZone, bl, list2, list3, n4, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "DisplayPerformance(artistId=" + this.artistId + ", performanceId=" + this.performanceId + ", artistName=" + this.artistName + ", gridSplitName=" + this.gridSplitName + ", artistDescription=" + this.artistDescription + ", artistImageUrl=" + this.artistImageUrl + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", stageKey=" + this.stageKey + ", stageIndex=" + this.stageIndex + ", stageName=" + this.stageName + ", stageColor=" + this.stageColor + ", stageComposeColor=" + Color.toString-impl((long)this.stageComposeColor) + ", tagColor=" + this.tagColor + ", tagComposeColor=" + this.tagComposeColor + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", startTimeString=" + this.startTimeString + ", endTimeString=" + this.endTimeString + ", startInstant=" + this.startInstant + ", endInstant=" + this.endInstant + ", dayOfWeek=" + this.dayOfWeek + ", favoriteState=" + this.favoriteState + ", alarmState=" + this.alarmState + ", seenState=" + this.seenState + ", genreList=" + this.genreList + ", zoneId=" + this.zoneId + ", isDeleted=" + this.isDeleted + ", conflicts=" + this.conflicts + ", socialList=" + this.socialList + ", version=" + this.version + ", isLastChangeNotifiable=" + this.isLastChangeNotifiable + ", isNewForChangeDialog=" + this.isNewForChangeDialog + ")";
    }

    public int hashCode() {
        int result = this.artistId.hashCode();
        result = result * 31 + this.performanceId.hashCode();
        result = result * 31 + this.artistName.hashCode();
        result = result * 31 + this.gridSplitName.hashCode();
        result = result * 31 + this.artistDescription.hashCode();
        result = result * 31 + this.artistImageUrl.hashCode();
        result = result * 31 + Integer.hashCode(this.imageWidth);
        result = result * 31 + Integer.hashCode(this.imageHeight);
        result = result * 31 + this.stageKey.hashCode();
        result = result * 31 + Integer.hashCode(this.stageIndex);
        result = result * 31 + this.stageName.hashCode();
        result = result * 31 + this.stageColor.hashCode();
        result = result * 31 + Color.hashCode-impl((long)this.stageComposeColor);
        result = result * 31 + (this.tagColor == null ? 0 : this.tagColor.hashCode());
        result = result * 31 + (this.tagComposeColor == null ? 0 : Color.hashCode-impl((long)this.tagComposeColor.unbox-impl()));
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + this.startTimeString.hashCode();
        result = result * 31 + this.endTimeString.hashCode();
        result = result * 31 + this.startInstant.hashCode();
        result = result * 31 + this.endInstant.hashCode();
        result = result * 31 + this.dayOfWeek.hashCode();
        result = result * 31 + this.favoriteState.hashCode();
        result = result * 31 + this.alarmState.hashCode();
        result = result * 31 + this.seenState.hashCode();
        result = result * 31 + ((Object)this.genreList).hashCode();
        result = result * 31 + this.zoneId.hashCode();
        result = result * 31 + Boolean.hashCode(this.isDeleted);
        result = result * 31 + ((Object)this.conflicts).hashCode();
        result = result * 31 + ((Object)this.socialList).hashCode();
        result = result * 31 + Integer.hashCode(this.version);
        result = result * 31 + Boolean.hashCode(this.isLastChangeNotifiable);
        result = result * 31 + Boolean.hashCode(this.isNewForChangeDialog);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplayPerformance)) {
            return false;
        }
        DisplayPerformance displayPerformance = (DisplayPerformance)other;
        if (!Intrinsics.areEqual((Object)this.artistId, (Object)displayPerformance.artistId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.performanceId, (Object)displayPerformance.performanceId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artistName, (Object)displayPerformance.artistName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.gridSplitName, displayPerformance.gridSplitName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artistDescription, (Object)displayPerformance.artistDescription)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artistImageUrl, (Object)displayPerformance.artistImageUrl)) {
            return false;
        }
        if (this.imageWidth != displayPerformance.imageWidth) {
            return false;
        }
        if (this.imageHeight != displayPerformance.imageHeight) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageKey, (Object)displayPerformance.stageKey)) {
            return false;
        }
        if (this.stageIndex != displayPerformance.stageIndex) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageName, (Object)displayPerformance.stageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageColor, (Object)displayPerformance.stageColor)) {
            return false;
        }
        if (!Color.equals-impl0((long)this.stageComposeColor, (long)displayPerformance.stageComposeColor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tagColor, (Object)displayPerformance.tagColor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tagComposeColor, (Object)displayPerformance.tagComposeColor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)displayPerformance.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)displayPerformance.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTimeString, (Object)displayPerformance.startTimeString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTimeString, (Object)displayPerformance.endTimeString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startInstant, (Object)displayPerformance.startInstant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endInstant, (Object)displayPerformance.endInstant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dayOfWeek, (Object)displayPerformance.dayOfWeek)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.favoriteState, (Object)displayPerformance.favoriteState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alarmState, (Object)displayPerformance.alarmState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.seenState, (Object)displayPerformance.seenState)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.genreList, displayPerformance.genreList)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.zoneId, (Object)displayPerformance.zoneId)) {
            return false;
        }
        if (this.isDeleted != displayPerformance.isDeleted) {
            return false;
        }
        if (!Intrinsics.areEqual(this.conflicts, displayPerformance.conflicts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.socialList, displayPerformance.socialList)) {
            return false;
        }
        if (this.version != displayPerformance.version) {
            return false;
        }
        if (this.isLastChangeNotifiable != displayPerformance.isLastChangeNotifiable) {
            return false;
        }
        return this.isNewForChangeDialog == displayPerformance.isNewForChangeDialog;
    }

    public /* synthetic */ DisplayPerformance(String artistId, String performanceId, String artistName, ImmutableList gridSplitName, String artistDescription, String artistImageUrl, int imageWidth, int imageHeight, String stageKey, int stageIndex, String stageName, String stageColor, long stageComposeColor, String tagColor, Color tagComposeColor, LocalDateTime startTime, LocalDateTime endTime, String startTimeString, String endTimeString, Instant startInstant, Instant endInstant, String dayOfWeek, FavoriteState favoriteState, AlarmState alarmState, SeenState seenState, List genreList, TimeZone zoneId, boolean isDeleted, List conflicts, List socialList, int version, boolean isLastChangeNotifiable, boolean isNewForChangeDialog, DefaultConstructorMarker $constructor_marker) {
        this(artistId, performanceId, artistName, (ImmutableList<String>)gridSplitName, artistDescription, artistImageUrl, imageWidth, imageHeight, stageKey, stageIndex, stageName, stageColor, stageComposeColor, tagColor, tagComposeColor, startTime, endTime, startTimeString, endTimeString, startInstant, endInstant, dayOfWeek, favoriteState, alarmState, seenState, genreList, zoneId, isDeleted, conflicts, socialList, version, isLastChangeNotifiable, isNewForChangeDialog);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jr\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0017\u00a8\u0006\u0018"}, d2={"Lmodels/DisplayPerformance$Companion;", "", "<init>", "()V", "from", "Lmodels/DisplayPerformance;", "yearData", "Ldata/account/model/YearData;", "timeFormat", "Lcommon/TimeFormat;", "stageList", "", "Ldata/account/model/Stage;", "artist", "Ldata/artist/model/Artist;", "performance", "Ldata/artist/model/Performance;", "favoriteList", "Ldata/artist/model/FavoritePerformance;", "alarmList", "", "seenList", "stageMap", "", "shared"})
    @SourceDebugExtension(value={"SMAP\nDisplayPerformance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayPerformance.kt\nmodels/DisplayPerformance$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n295#2,2:223\n1563#2:225\n1634#2,2:226\n1617#2,9:228\n1869#2:237\n1870#2:239\n1626#2:240\n1636#2:241\n295#2,2:242\n360#2,7:244\n1#3:238\n*S KotlinDebug\n*F\n+ 1 DisplayPerformance.kt\nmodels/DisplayPerformance$Companion\n*L\n146#1:223,2\n163#1:225\n163#1:226,2\n167#1:228,9\n167#1:237\n167#1:239\n167#1:240\n163#1:241\n180#1:242,2\n194#1:244,7\n167#1:238\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DisplayPerformance from(@NotNull YearData yearData, @NotNull TimeFormat timeFormat, @NotNull List<Stage> stageList, @NotNull Artist artist, @NotNull Performance performance, @NotNull List<FavoritePerformance> favoriteList, @NotNull List<String> alarmList, @NotNull List<String> seenList, @NotNull Map<String, Stage> stageMap) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            String string2;
            int n2;
            int n3;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            TagColor tagColor;
            ImmutableList splitName;
            Object object6;
            String dayOfWeek;
            block17: {
                int n4;
                String string8;
                Object v7;
                block16: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object v0;
                    Object element$iv2;
                    block15: {
                        void $this$firstOrNull$iv;
                        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
                        Intrinsics.checkNotNullParameter((Object)timeFormat, (String)"timeFormat");
                        Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
                        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
                        Intrinsics.checkNotNullParameter((Object)performance, (String)"performance");
                        Intrinsics.checkNotNullParameter(favoriteList, (String)"favoriteList");
                        Intrinsics.checkNotNullParameter(alarmList, (String)"alarmList");
                        Intrinsics.checkNotNullParameter(seenList, (String)"seenList");
                        Intrinsics.checkNotNullParameter(stageMap, (String)"stageMap");
                        List dateList = !((Collection)yearData.getDateList()).isEmpty() ? CollectionsKt.plus((Collection)yearData.getDateList(), (Object)LocalDateTimeExtensionsKt.plus$default((LocalDateTime)CollectionsKt.last(yearData.getDateList()), 24, DateTimeUnit.Companion.getHOUR(), null, 4, null)) : yearData.getDateList();
                        Iterable iterable = dateList;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            LocalDateTime it22 = (LocalDateTime)element$iv2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it22.getDate(), (Object)performance.getStartTime().getDate())) continue;
                            v0 = element$iv2;
                            break block15;
                        }
                        v0 = null;
                    }
                    LocalDateTime dateListMatch = v0;
                    String string9 = (dateListMatch == null ? "" : (dateListMatch.compareTo(performance.getStartTime()) > 0 ? InstantExtensionsKt.toLocalDateTimeUTC(InstantKt.minus((Instant)LocalDateTimeExtensionsKt.toInstantUTC(performance.getStartTime()), (int)24, (DateTimeUnit.TimeBased)DateTimeUnit.Companion.getHOUR())).getDayOfWeek().toString() : performance.getStartTime().getDayOfWeek().toString())).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                    dayOfWeek = StringKt.capitalize((String)string9, (androidx.compose.ui.text.intl.Locale)androidx.compose.ui.text.intl.Locale.Companion.getCurrent());
                    Object object7 = artist.getName();
                    element$iv2 = DisplayPerformanceKt.access$getGridNameSplitRegex$p();
                    int it22 = 0;
                    object7 = element$iv2.split((CharSequence)object7, it22);
                    boolean $i$f$map = false;
                    void it22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        List list;
                        void text;
                        String string10 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String[] stringArray = new String[]{" "};
                        List spaceSplit = StringsKt.split$default((CharSequence)((CharSequence)text), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        if (((Collection)spaceSplit).size() > 1) {
                            void $this$mapNotNullTo$iv$iv;
                            Iterable $this$mapNotNull$iv = spaceSplit;
                            boolean $i$f$mapNotNull = false;
                            Iterable iterable = $this$mapNotNull$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            object6 = $this$forEach$iv$iv$iv.iterator();
                            while (object6.hasNext()) {
                                String it$iv$iv;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = object6.next();
                                boolean bl2 = false;
                                String it = (String)element$iv$iv;
                                boolean bl3 = false;
                                if ((((CharSequence)it).length() == 0 ? null : ((Object)StringsKt.trim((CharSequence)it)).toString() + " ") == null) continue;
                                it$iv$iv = it$iv$iv;
                                boolean bl4 = false;
                                destination$iv$iv2.add(it$iv$iv);
                            }
                            list = (List)destination$iv$iv2;
                        } else {
                            list = spaceSplit;
                        }
                        collection.add(list);
                    }
                    splitName = ExtensionsKt.toImmutableList((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
                    Iterable $this$firstOrNull$iv = yearData.getTagColorList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        String string11;
                        TagColor it = (TagColor)element$iv3;
                        boolean bl = false;
                        String string12 = it.getTag().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toLowerCase(...)");
                        String string13 = (String)CollectionsKt.firstOrNull(artist.getGenreList());
                        if (string13 != null) {
                            String string14 = string13.toLowerCase(Locale.ROOT);
                            string11 = string14;
                            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toLowerCase(...)");
                        } else {
                            string11 = null;
                        }
                        if (!Intrinsics.areEqual((Object)string12, (Object)string11)) continue;
                        v7 = element$iv3;
                        break block16;
                    }
                    v7 = null;
                }
                tagColor = v7;
                string7 = artist.getArtistId();
                string6 = performance.getPerformanceId();
                string5 = artist.getName();
                String string15 = artist.getDescription();
                if (string15 == null) {
                    string15 = string4 = "";
                }
                if ((string8 = artist.getImageUrl()) == null) {
                    string8 = "";
                }
                string3 = string8;
                n3 = artist.getImageWidth();
                n2 = artist.getImageHeight();
                string2 = performance.getStageKey();
                List<Stage> $this$indexOfFirst$iv = stageList;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Stage> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Stage item$iv;
                    Stage it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getKey(), (Object)performance.getStageKey())) {
                        n4 = index$iv;
                        break block17;
                    }
                    ++index$iv;
                }
                n4 = n = -1;
            }
            if ((object5 = stageMap.get(performance.getStageKey())) == null || (object5 = ((Stage)object5).getName()) == null) {
                object5 = object4 = "";
            }
            if ((object3 = stageMap.get(performance.getStageKey())) == null || (object3 = ((Stage)object3).getColor()) == null) {
                object3 = object2 = "#ffffff";
            }
            if ((object = stageMap.get(performance.getStageKey())) == null || (object = ((Stage)object).getColor()) == null) {
                object = "#ffffff";
            }
            long l = ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke((String)object)));
            TagColor tagColor2 = tagColor;
            String string16 = tagColor2 != null ? tagColor2.getColor() : null;
            TagColor tagColor3 = tagColor;
            Color color = tagColor3 != null ? Color.box-impl((long)ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke(tagColor3.getColor())))) : null;
            String string17 = LocalDateTimeExtensionsKt.toDisplayTime$default(performance.getStartTime(), timeFormat, null, 2, null);
            object6 = LocalDateTimeExtensionsKt.toDisplayTime$default(performance.getEndTime(), timeFormat, null, 2, null);
            LocalDateTime localDateTime = performance.getStartTime();
            LocalDateTime localDateTime2 = performance.getEndTime();
            Instant instant = LocalDateTimeExtensionsKt.toInstantUTC(performance.getStartTime());
            Instant instant2 = LocalDateTimeExtensionsKt.toInstantUTC(performance.getEndTime());
            List<String> list = artist.getGenreList();
            FavoriteState favoriteState = FavoriteState.Companion.getFavoriteState(performance, favoriteList);
            SeenState seenState = SeenState.Companion.getSeenState(performance, seenList);
            AlarmState alarmState = AlarmState.Companion.getAlarmState(performance, alarmList);
            boolean bl = performance.isDeleted();
            TimeZone timeZone = yearData.getZoneId();
            List list2 = CollectionsKt.emptyList();
            List<String> list3 = artist.getSocialList();
            int n5 = artist.getVersion();
            boolean bl5 = artist.isLatestChangeNotifiable();
            return new DisplayPerformance(string7, string6, string5, splitName, string4, string3, n3, n2, string2, n, (String)object4, (String)object2, l, string16, color, localDateTime, localDateTime2, string17, (String)object6, instant, instant2, dayOfWeek, favoriteState, alarmState, seenState, list, timeZone, bl, list2, list3, n5, bl5, false, 0, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

