/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.draftSchedule;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.StringKt;
import com.github.ajalt.colormath.extensions.android.composecolor.ComposeColorExtensionsKt;
import com.github.ajalt.colormath.model.RGB;
import common.TimeFormat;
import common.states.FavoriteState;
import data.account.model.Stage;
import data.account.model.TagColor;
import di.IsValidUrl_desktopKt;
import extensions.LocalDateTimeExtensionsKt;
import extensions.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import models.DisplayPerformance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.elements.artist.AlarmState;
import ui.elements.artist.SeenState;
import ui.screens.FestivalDay;
import ui.screens.draftSchedule.AddPerformanceType;
import ui.screens.draftSchedule.editing.ImageType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"\b\u0087\b\u0018\u0000 V2\u00020\u0001:\u0001VB\u00a9\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020.2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020.2\u0006\u00104\u001a\u000205J\u001c\u00107\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0003J\"\u00109\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u0010:\u001a\u00020\u0003J\"\u0010;\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u0010:\u001a\u00020\u0003J\u0006\u0010<\u001a\u00020.J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0007H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\nH\u00c6\u0003J\t\u0010H\u001a\u00020\fH\u00c6\u0003J\t\u0010I\u001a\u00020\fH\u00c6\u0003J\t\u0010J\u001a\u00020\nH\u00c6\u0003J\t\u0010K\u001a\u00020\fH\u00c6\u0003J\t\u0010L\u001a\u00020\fH\u00c6\u0003J\t\u0010M\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u00c6\u0003J\t\u0010O\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u00c6\u0003J\u00ab\u0001\u0010Q\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00032\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u00c6\u0001J\u0013\u0010R\u001a\u00020.2\b\u0010S\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010T\u001a\u00020\fH\u00d6\u0001J\t\u0010U\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001aR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0011\u0010=\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\bA\u0010?\u00a8\u0006W"}, d2={"Lui/screens/draftSchedule/DraftEditedChanges;", "", "performanceId", "", "artistName", "description", "imageType", "Lui/screens/draftSchedule/editing/ImageType;", "stageKey", "startDay", "Lkotlinx/datetime/LocalDate;", "startHour", "", "startMinute", "endDay", "endHour", "endMinute", "genreList", "socialList", "", "newSocial", "conflicts", "Lmodels/DisplayPerformance;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lui/screens/draftSchedule/editing/ImageType;Ljava/lang/String;Lkotlinx/datetime/LocalDate;IILkotlinx/datetime/LocalDate;IILjava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "getPerformanceId", "()Ljava/lang/String;", "getArtistName", "getDescription", "getImageType", "()Lui/screens/draftSchedule/editing/ImageType;", "getStageKey", "getStartDay", "()Lkotlinx/datetime/LocalDate;", "getStartHour", "()I", "getStartMinute", "getEndDay", "getEndHour", "getEndMinute", "getGenreList", "getSocialList", "()Ljava/util/List;", "getNewSocial", "getConflicts", "isEditing", "", "isContentSaveable", "displayPerformance", "festivalDay", "Lui/screens/FestivalDay;", "isStartTimeFrameInvalid", "startOfDay", "Lkotlinx/datetime/LocalDateTime;", "isEndTimeFrameInvalid", "isDifferent", "newFromStageKey", "toTempDisplayPerformance", "idWhenNullDisplay", "toTempDisplayPerformanceForGridOnly", "isSocialLinksInvalid", "startTime", "getStartTime", "()Lkotlinx/datetime/LocalDateTime;", "endTime", "getEndTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "other", "hashCode", "toString", "Companion", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDraftEditedChanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DraftEditedChanges.kt\nui/screens/draftSchedule/DraftEditedChanges\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n295#2,2:260\n295#2,2:262\n360#2,7:264\n295#2,2:271\n295#2,2:273\n295#2,2:275\n360#2,7:277\n295#2,2:284\n1563#2:286\n1634#2,3:287\n*S KotlinDebug\n*F\n+ 1 DraftEditedChanges.kt\nui/screens/draftSchedule/DraftEditedChanges\n*L\n102#1:260,2\n106#1:262,2\n120#1:264,7\n121#1:271,2\n163#1:273,2\n167#1:275,2\n181#1:277,7\n182#1:284,2\n212#1:286\n212#1:287,3\n*E\n"})
public final class DraftEditedChanges {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String performanceId;
    @NotNull
    private final String artistName;
    @NotNull
    private final String description;
    @NotNull
    private final ImageType imageType;
    @NotNull
    private final String stageKey;
    @NotNull
    private final LocalDate startDay;
    private final int startHour;
    private final int startMinute;
    @NotNull
    private final LocalDate endDay;
    private final int endHour;
    private final int endMinute;
    @NotNull
    private final String genreList;
    @NotNull
    private final List<String> socialList;
    @NotNull
    private final String newSocial;
    @NotNull
    private final List<DisplayPerformance> conflicts;
    public static final int $stable = 8;

    public DraftEditedChanges(@NotNull String performanceId, @NotNull String artistName, @NotNull String description, @NotNull ImageType imageType, @NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute, @NotNull LocalDate endDay, int endHour, int endMinute, @NotNull String genreList, @NotNull List<String> socialList, @NotNull String newSocial, @NotNull List<DisplayPerformance> conflicts) {
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
        Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
        Intrinsics.checkNotNullParameter((Object)endDay, (String)"endDay");
        Intrinsics.checkNotNullParameter((Object)genreList, (String)"genreList");
        Intrinsics.checkNotNullParameter(socialList, (String)"socialList");
        Intrinsics.checkNotNullParameter((Object)newSocial, (String)"newSocial");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        this.performanceId = performanceId;
        this.artistName = artistName;
        this.description = description;
        this.imageType = imageType;
        this.stageKey = stageKey;
        this.startDay = startDay;
        this.startHour = startHour;
        this.startMinute = startMinute;
        this.endDay = endDay;
        this.endHour = endHour;
        this.endMinute = endMinute;
        this.genreList = genreList;
        this.socialList = socialList;
        this.newSocial = newSocial;
        this.conflicts = conflicts;
    }

    public /* synthetic */ DraftEditedChanges(String string2, String string3, String string4, ImageType imageType, String string5, LocalDate localDate, int n, int n2, LocalDate localDate2, int n3, int n4, String string6, List list, String string7, List list2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            string2 = "";
        }
        if ((n5 & 2) != 0) {
            string3 = "";
        }
        if ((n5 & 4) != 0) {
            string4 = "";
        }
        if ((n5 & 8) != 0) {
            imageType = ImageType.None.INSTANCE;
        }
        if ((n5 & 0x10) != 0) {
            string5 = "";
        }
        if ((n5 & 0x20) != 0) {
            localDate = new LocalDate(2000, 1, 1);
        }
        if ((n5 & 0x40) != 0) {
            n = 0;
        }
        if ((n5 & 0x80) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x100) != 0) {
            localDate2 = new LocalDate(2000, 1, 1);
        }
        if ((n5 & 0x200) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x400) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x800) != 0) {
            string6 = "";
        }
        if ((n5 & 0x1000) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n5 & 0x2000) != 0) {
            string7 = "";
        }
        if ((n5 & 0x4000) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string2, string3, string4, imageType, string5, localDate, n, n2, localDate2, n3, n4, string6, list, string7, list2);
    }

    @NotNull
    public final String getPerformanceId() {
        return this.performanceId;
    }

    @NotNull
    public final String getArtistName() {
        return this.artistName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final ImageType getImageType() {
        return this.imageType;
    }

    @NotNull
    public final String getStageKey() {
        return this.stageKey;
    }

    @NotNull
    public final LocalDate getStartDay() {
        return this.startDay;
    }

    public final int getStartHour() {
        return this.startHour;
    }

    public final int getStartMinute() {
        return this.startMinute;
    }

    @NotNull
    public final LocalDate getEndDay() {
        return this.endDay;
    }

    public final int getEndHour() {
        return this.endHour;
    }

    public final int getEndMinute() {
        return this.endMinute;
    }

    @NotNull
    public final String getGenreList() {
        return this.genreList;
    }

    @NotNull
    public final List<String> getSocialList() {
        return this.socialList;
    }

    @NotNull
    public final String getNewSocial() {
        return this.newSocial;
    }

    @NotNull
    public final List<DisplayPerformance> getConflicts() {
        return this.conflicts;
    }

    public final boolean isEditing() {
        return !Intrinsics.areEqual((Object)this.startDay, (Object)new LocalDate(2000, 1, 1));
    }

    public final boolean isContentSaveable(@Nullable DisplayPerformance displayPerformance, @NotNull FestivalDay festivalDay2) {
        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
        return ((CharSequence)this.artistName).length() == 0 ? false : (this.isStartTimeFrameInvalid(festivalDay2.getStartTime()) ? false : (this.isEndTimeFrameInvalid(festivalDay2.getStartTime()) ? false : (this.isSocialLinksInvalid() ? false : DraftEditedChanges.isDifferent$default(this, displayPerformance, null, 2, null))));
    }

    public final boolean isStartTimeFrameInvalid(@NotNull LocalDateTime startOfDay) {
        Intrinsics.checkNotNullParameter((Object)startOfDay, (String)"startOfDay");
        return this.getStartTime().compareTo(this.getEndTime()) >= 0 || this.getStartTime().compareTo(startOfDay) < 0;
    }

    public final boolean isEndTimeFrameInvalid(@NotNull LocalDateTime startOfDay) {
        Intrinsics.checkNotNullParameter((Object)startOfDay, (String)"startOfDay");
        LocalDateTime currentStartOfDay = new LocalDateTime(this.startDay, new LocalTime(startOfDay.getHour(), startOfDay.getMinute(), 0, 0, 12, null));
        return this.getStartTime().compareTo(currentStartOfDay) < 0 && this.getEndTime().compareTo(currentStartOfDay) > 0 || this.getStartTime().compareTo(currentStartOfDay) > 0 && this.getEndTime().compareTo(LocalDateTimeExtensionsKt.plus$default(currentStartOfDay, 24, DateTimeUnit.Companion.getHOUR(), null, 4, null)) > 0;
    }

    public final boolean isDifferent(@Nullable DisplayPerformance displayPerformance, @Nullable String newFromStageKey) {
        List<String> genres = StringExtensionsKt.commaSeparatedToList(this.genreList);
        return displayPerformance == null ? !Intrinsics.areEqual((Object)this.artistName, (Object)"") || !Intrinsics.areEqual((Object)this.description, (Object)"") || !Intrinsics.areEqual((Object)this.stageKey, (Object)"") && !Intrinsics.areEqual((Object)this.stageKey, (Object)newFromStageKey) || !Intrinsics.areEqual((Object)this.genreList, (Object)"") || !((Collection)this.socialList).isEmpty() || ((CharSequence)this.newSocial).length() > 0 || !Intrinsics.areEqual((Object)this.imageType, (Object)ImageType.None.INSTANCE) : (StringExtensionsKt.doesNotStartWith(displayPerformance.getPerformanceId(), "PID") ? true : (!Intrinsics.areEqual((Object)displayPerformance.getArtistName(), (Object)this.artistName) ? true : (!Intrinsics.areEqual((Object)displayPerformance.getStageKey(), (Object)this.stageKey) ? true : (!Intrinsics.areEqual((Object)displayPerformance.getStartTime(), (Object)this.getStartTime()) ? true : (!Intrinsics.areEqual((Object)displayPerformance.getEndTime(), (Object)this.getEndTime()) ? true : (!Intrinsics.areEqual(displayPerformance.getGenreList(), genres) ? true : (!Intrinsics.areEqual((Object)displayPerformance.getArtistDescription(), (Object)this.description) ? true : (!Intrinsics.areEqual(displayPerformance.getSocialList(), this.socialList) ? true : (((CharSequence)this.newSocial).length() > 0 ? true : ImageType.Companion.from(displayPerformance).getClass() != this.imageType.getClass())))))))));
    }

    public static /* synthetic */ boolean isDifferent$default(DraftEditedChanges draftEditedChanges, DisplayPerformance displayPerformance, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return draftEditedChanges.isDifferent(displayPerformance, string2);
    }

    @NotNull
    public final DisplayPerformance toTempDisplayPerformance(@NotNull FestivalDay festivalDay2, @Nullable DisplayPerformance displayPerformance, @NotNull String idWhenNullDisplay) {
        List<DisplayPerformance> list;
        Object object;
        Object v12;
        int n;
        Object object2;
        String string2;
        int n2;
        int n3;
        String string3;
        String string4;
        Object object3;
        TagColor tagColor;
        List<String> genreList;
        Stage stage;
        Object object4;
        block15: {
            int n4;
            block14: {
                Object object5;
                Object v5;
                block13: {
                    Object v0;
                    block12: {
                        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
                        Intrinsics.checkNotNullParameter((Object)idWhenNullDisplay, (String)"idWhenNullDisplay");
                        Iterable $this$firstOrNull$iv = festivalDay2.getStageList();
                        boolean $i$f$firstOrNull = false;
                        object4 = $this$firstOrNull$iv.iterator();
                        while (object4.hasNext()) {
                            Object element$iv = object4.next();
                            Stage it = (Stage)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) continue;
                            v0 = element$iv;
                            break block12;
                        }
                        v0 = null;
                    }
                    stage = v0;
                    genreList = StringExtensionsKt.commaSeparatedToList(this.genreList);
                    Iterable $this$firstOrNull$iv = festivalDay2.getYearData().getTagColorList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String string5;
                        TagColor it = (TagColor)element$iv;
                        boolean bl = false;
                        String string6 = it.getTag().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                        String string7 = (String)CollectionsKt.firstOrNull(genreList);
                        if (string7 != null) {
                            String string8 = string7.toLowerCase(Locale.ROOT);
                            string5 = string8;
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                        } else {
                            string5 = null;
                        }
                        if (!Intrinsics.areEqual((Object)string6, (Object)string5)) continue;
                        v5 = element$iv;
                        break block13;
                    }
                    v5 = null;
                }
                tagColor = v5;
                Object object6 = displayPerformance;
                if (object6 == null || (object6 = ((DisplayPerformance)object6).getArtistId()) == null) {
                    object6 = object4 = idWhenNullDisplay;
                }
                if ((object5 = displayPerformance) == null || (object5 = ((DisplayPerformance)object5).getPerformanceId()) == null) {
                    object5 = idWhenNullDisplay;
                }
                object3 = object5;
                string4 = this.artistName;
                string3 = this.description;
                DisplayPerformance displayPerformance2 = displayPerformance;
                n3 = displayPerformance2 != null ? displayPerformance2.getImageWidth() : 0;
                DisplayPerformance displayPerformance3 = displayPerformance;
                n2 = displayPerformance3 != null ? displayPerformance3.getImageHeight() : 0;
                string2 = this.stageKey;
                Object object7 = stage;
                if (object7 == null || (object7 = ((Stage)object7).getName()) == null) {
                    object7 = "";
                }
                object2 = object7;
                List<Stage> $this$indexOfFirst$iv = festivalDay2.getStageList();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Stage> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Stage item$iv;
                    Stage it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) {
                        n4 = index$iv;
                        break block14;
                    }
                    ++index$iv;
                }
                n4 = -1;
            }
            n = n4;
            Iterable $this$firstOrNull$iv = festivalDay2.getStageList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Stage it = (Stage)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) continue;
                v12 = element$iv;
                break block15;
            }
            v12 = null;
        }
        if ((object = (Stage)v12) == null || (object = ((Stage)object).getColor()) == null) {
            object = "#FFFFFF";
        }
        Object object8 = object;
        Stage stage2 = stage;
        long l = stage2 == null ? Color.Companion.getWhite-0d7_KjU() : ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke(stage2.getColor())));
        TagColor tagColor2 = tagColor;
        String string9 = tagColor2 != null ? tagColor2.getColor() : null;
        TagColor tagColor3 = tagColor;
        Iterator iterator = tagColor3 != null ? Color.box-impl((long)ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke(tagColor3.getColor())))) : null;
        LocalDateTime localDateTime = this.getStartTime();
        LocalDateTime localDateTime2 = this.getEndTime();
        Instant instant = LocalDateTimeExtensionsKt.toInstantUTC(this.getStartTime());
        Instant instant2 = LocalDateTimeExtensionsKt.toInstantUTC(this.getEndTime());
        String string10 = this.startDay.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        String string11 = StringKt.capitalize((String)string10, (androidx.compose.ui.text.intl.Locale)androidx.compose.ui.text.intl.Locale.Companion.getCurrent()) + " " + this.startDay.getDayOfMonth();
        FavoriteState.NotFavorite notFavorite = FavoriteState.NotFavorite.INSTANCE;
        AlarmState.NotSet notSet = AlarmState.NotSet.INSTANCE;
        SeenState.NotSeen notSeen = SeenState.NotSeen.INSTANCE;
        DisplayPerformance displayPerformance4 = displayPerformance;
        if (displayPerformance4 == null || (displayPerformance4 = displayPerformance4.getZoneId()) == null) {
            displayPerformance4 = TimeZone.Companion.of(TimeZone.Companion.getUTC().toString());
        }
        DisplayPerformance displayPerformance5 = displayPerformance4;
        List<DisplayPerformance> $this$toTempDisplayPerformance_u24lambda_u244 = list = CollectionsKt.toMutableList((Collection)this.socialList);
        boolean bl = false;
        $this$toTempDisplayPerformance_u24lambda_u244.add((DisplayPerformance)((Object)this.newSocial));
        List<DisplayPerformance> list2 = list;
        list = this.conflicts;
        String string12 = LocalDateTimeExtensionsKt.toDisplayTime$default(this.getStartTime(), TimeFormat.Twelve.INSTANCE, null, 2, null);
        String string13 = LocalDateTimeExtensionsKt.toDisplayTime$default(this.getEndTime(), TimeFormat.Twelve.INSTANCE, null, 2, null);
        ImmutableList immutableList = ExtensionsKt.toImmutableList((Iterable)CollectionsKt.listOf((Object)this.artistName));
        DisplayPerformance displayPerformance6 = displayPerformance;
        int n5 = displayPerformance6 != null ? displayPerformance6.getVersion() : 1;
        return new DisplayPerformance((String)object4, (String)object3, string4, immutableList, string3, "", n3, n2, string2, n, (String)object2, (String)object8, l, string9, (Color)iterator, localDateTime, localDateTime2, string12, string13, instant, instant2, string11, notFavorite, notSet, notSeen, genreList, (TimeZone)displayPerformance5, false, list, list2, n5, false, false, 0, 1, null);
    }

    public static /* synthetic */ DisplayPerformance toTempDisplayPerformance$default(DraftEditedChanges draftEditedChanges, FestivalDay festivalDay2, DisplayPerformance displayPerformance, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            displayPerformance = null;
        }
        return draftEditedChanges.toTempDisplayPerformance(festivalDay2, displayPerformance, string2);
    }

    @NotNull
    public final DisplayPerformance toTempDisplayPerformanceForGridOnly(@NotNull FestivalDay festivalDay2, @Nullable DisplayPerformance displayPerformance, @NotNull String idWhenNullDisplay) {
        Object object;
        Object v12;
        int n;
        Object object2;
        String string2;
        int n2;
        int n3;
        String string3;
        Object object3;
        TagColor tagColor;
        List<String> genreList;
        Stage stage;
        Object object4;
        block15: {
            int n4;
            block14: {
                Object object5;
                Object v5;
                block13: {
                    Object v0;
                    block12: {
                        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
                        Intrinsics.checkNotNullParameter((Object)idWhenNullDisplay, (String)"idWhenNullDisplay");
                        Iterable $this$firstOrNull$iv = festivalDay2.getStageList();
                        boolean $i$f$firstOrNull = false;
                        object4 = $this$firstOrNull$iv.iterator();
                        while (object4.hasNext()) {
                            Object element$iv = object4.next();
                            Stage it = (Stage)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) continue;
                            v0 = element$iv;
                            break block12;
                        }
                        v0 = null;
                    }
                    stage = v0;
                    genreList = StringExtensionsKt.commaSeparatedToList(this.genreList);
                    Iterable $this$firstOrNull$iv = festivalDay2.getYearData().getTagColorList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String string4;
                        TagColor it = (TagColor)element$iv;
                        boolean bl = false;
                        String string5 = it.getTag().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        String string6 = (String)CollectionsKt.firstOrNull(genreList);
                        if (string6 != null) {
                            String string7 = string6.toLowerCase(Locale.ROOT);
                            string4 = string7;
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                        } else {
                            string4 = null;
                        }
                        if (!Intrinsics.areEqual((Object)string5, (Object)string4)) continue;
                        v5 = element$iv;
                        break block13;
                    }
                    v5 = null;
                }
                tagColor = v5;
                Object object6 = displayPerformance;
                if (object6 == null || (object6 = ((DisplayPerformance)object6).getArtistId()) == null) {
                    object6 = object4 = idWhenNullDisplay;
                }
                if ((object5 = displayPerformance) == null || (object5 = ((DisplayPerformance)object5).getPerformanceId()) == null) {
                    object5 = idWhenNullDisplay;
                }
                object3 = object5;
                string3 = this.artistName;
                DisplayPerformance displayPerformance2 = displayPerformance;
                n3 = displayPerformance2 != null ? displayPerformance2.getImageWidth() : 0;
                DisplayPerformance displayPerformance3 = displayPerformance;
                n2 = displayPerformance3 != null ? displayPerformance3.getImageHeight() : 0;
                string2 = this.stageKey;
                Object object7 = stage;
                if (object7 == null || (object7 = ((Stage)object7).getName()) == null) {
                    object7 = "";
                }
                object2 = object7;
                List<Stage> $this$indexOfFirst$iv = festivalDay2.getStageList();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Stage> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Stage item$iv;
                    Stage it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) {
                        n4 = index$iv;
                        break block14;
                    }
                    ++index$iv;
                }
                n4 = -1;
            }
            n = n4;
            Iterable $this$firstOrNull$iv = festivalDay2.getStageList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Stage it = (Stage)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.stageKey)) continue;
                v12 = element$iv;
                break block15;
            }
            v12 = null;
        }
        if ((object = (Stage)v12) == null || (object = ((Stage)object).getColor()) == null) {
            object = "#FFFFFF";
        }
        Object object8 = object;
        Stage stage2 = stage;
        long l = stage2 == null ? Color.Companion.getWhite-0d7_KjU() : ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke(stage2.getColor())));
        TagColor tagColor2 = tagColor;
        String string8 = tagColor2 != null ? tagColor2.getColor() : null;
        TagColor tagColor3 = tagColor;
        Iterator iterator = tagColor3 != null ? Color.box-impl((long)ComposeColorExtensionsKt.toComposeColor((com.github.ajalt.colormath.Color)((com.github.ajalt.colormath.Color)RGB.Companion.invoke(tagColor3.getColor())))) : null;
        LocalDateTime localDateTime = this.getStartTime();
        LocalDateTime localDateTime2 = this.getEndTime();
        Instant instant = LocalDateTimeExtensionsKt.toInstantUTC(this.getStartTime());
        Instant instant2 = LocalDateTimeExtensionsKt.toInstantUTC(this.getEndTime());
        String string9 = this.startDay.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        String string10 = StringKt.capitalize((String)string9, (androidx.compose.ui.text.intl.Locale)androidx.compose.ui.text.intl.Locale.Companion.getCurrent()) + " " + this.startDay.getDayOfMonth();
        FavoriteState.NotFavorite notFavorite = FavoriteState.NotFavorite.INSTANCE;
        AlarmState.NotSet notSet = AlarmState.NotSet.INSTANCE;
        SeenState.NotSeen notSeen = SeenState.NotSeen.INSTANCE;
        List<String> list = festivalDay2.getYearData().getTagColorList().isEmpty() ? CollectionsKt.emptyList() : genreList;
        DisplayPerformance displayPerformance4 = displayPerformance;
        if (displayPerformance4 == null || (displayPerformance4 = displayPerformance4.getZoneId()) == null) {
            displayPerformance4 = TimeZone.Companion.of(TimeZone.Companion.getUTC().toString());
        }
        DisplayPerformance displayPerformance5 = displayPerformance4;
        List list2 = CollectionsKt.emptyList();
        List<DisplayPerformance> list3 = this.conflicts;
        String string11 = LocalDateTimeExtensionsKt.toDisplayTime$default(this.getStartTime(), TimeFormat.Twelve.INSTANCE, null, 2, null);
        String string12 = LocalDateTimeExtensionsKt.toDisplayTime$default(this.getEndTime(), TimeFormat.Twelve.INSTANCE, null, 2, null);
        ImmutableList immutableList = ExtensionsKt.toImmutableList((Iterable)CollectionsKt.listOf((Object)this.artistName));
        DisplayPerformance displayPerformance6 = displayPerformance;
        int n5 = displayPerformance6 != null ? displayPerformance6.getVersion() : 1;
        return new DisplayPerformance((String)object4, (String)object3, string3, immutableList, "", "", n3, n2, string2, n, (String)object2, (String)object8, l, string8, (Color)iterator, localDateTime, localDateTime2, string11, string12, instant, instant2, string10, notFavorite, notSet, notSeen, list, (TimeZone)displayPerformance5, false, list3, list2, n5, false, false, 0, 1, null);
    }

    public static /* synthetic */ DisplayPerformance toTempDisplayPerformanceForGridOnly$default(DraftEditedChanges draftEditedChanges, FestivalDay festivalDay2, DisplayPerformance displayPerformance, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            displayPerformance = null;
        }
        return draftEditedChanges.toTempDisplayPerformanceForGridOnly(festivalDay2, displayPerformance, string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSocialLinksInvalid() {
        void $this$mapTo$iv$iv;
        if (!IsValidUrl_desktopKt.isValidUrl(this.newSocial)) {
            if (((CharSequence)this.newSocial).length() > 0) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        Iterable $this$map$iv = this.socialList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IsValidUrl_desktopKt.isValidUrl((String)it));
        }
        if (!((List)destination$iv$iv).contains(false)) return false;
        return true;
    }

    @NotNull
    public final LocalDateTime getStartTime() {
        return new LocalDateTime(this.startDay.getYear(), this.startDay.getMonthNumber(), this.startDay.getDayOfMonth(), this.startHour, this.startMinute, 0, 0, 96, null);
    }

    @NotNull
    public final LocalDateTime getEndTime() {
        return new LocalDateTime(this.endDay.getYear(), this.endDay.getMonthNumber(), this.endDay.getDayOfMonth(), this.endHour, this.endMinute, 0, 0, 96, null);
    }

    @NotNull
    public final String component1() {
        return this.performanceId;
    }

    @NotNull
    public final String component2() {
        return this.artistName;
    }

    @NotNull
    public final String component3() {
        return this.description;
    }

    @NotNull
    public final ImageType component4() {
        return this.imageType;
    }

    @NotNull
    public final String component5() {
        return this.stageKey;
    }

    @NotNull
    public final LocalDate component6() {
        return this.startDay;
    }

    public final int component7() {
        return this.startHour;
    }

    public final int component8() {
        return this.startMinute;
    }

    @NotNull
    public final LocalDate component9() {
        return this.endDay;
    }

    public final int component10() {
        return this.endHour;
    }

    public final int component11() {
        return this.endMinute;
    }

    @NotNull
    public final String component12() {
        return this.genreList;
    }

    @NotNull
    public final List<String> component13() {
        return this.socialList;
    }

    @NotNull
    public final String component14() {
        return this.newSocial;
    }

    @NotNull
    public final List<DisplayPerformance> component15() {
        return this.conflicts;
    }

    @NotNull
    public final DraftEditedChanges copy(@NotNull String performanceId, @NotNull String artistName, @NotNull String description, @NotNull ImageType imageType, @NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute, @NotNull LocalDate endDay, int endHour, int endMinute, @NotNull String genreList, @NotNull List<String> socialList, @NotNull String newSocial, @NotNull List<DisplayPerformance> conflicts) {
        Intrinsics.checkNotNullParameter((Object)performanceId, (String)"performanceId");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
        Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
        Intrinsics.checkNotNullParameter((Object)endDay, (String)"endDay");
        Intrinsics.checkNotNullParameter((Object)genreList, (String)"genreList");
        Intrinsics.checkNotNullParameter(socialList, (String)"socialList");
        Intrinsics.checkNotNullParameter((Object)newSocial, (String)"newSocial");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        return new DraftEditedChanges(performanceId, artistName, description, imageType, stageKey, startDay, startHour, startMinute, endDay, endHour, endMinute, genreList, socialList, newSocial, conflicts);
    }

    public static /* synthetic */ DraftEditedChanges copy$default(DraftEditedChanges draftEditedChanges, String string2, String string3, String string4, ImageType imageType, String string5, LocalDate localDate, int n, int n2, LocalDate localDate2, int n3, int n4, String string6, List list, String string7, List list2, int n5, Object object) {
        if ((n5 & 1) != 0) {
            string2 = draftEditedChanges.performanceId;
        }
        if ((n5 & 2) != 0) {
            string3 = draftEditedChanges.artistName;
        }
        if ((n5 & 4) != 0) {
            string4 = draftEditedChanges.description;
        }
        if ((n5 & 8) != 0) {
            imageType = draftEditedChanges.imageType;
        }
        if ((n5 & 0x10) != 0) {
            string5 = draftEditedChanges.stageKey;
        }
        if ((n5 & 0x20) != 0) {
            localDate = draftEditedChanges.startDay;
        }
        if ((n5 & 0x40) != 0) {
            n = draftEditedChanges.startHour;
        }
        if ((n5 & 0x80) != 0) {
            n2 = draftEditedChanges.startMinute;
        }
        if ((n5 & 0x100) != 0) {
            localDate2 = draftEditedChanges.endDay;
        }
        if ((n5 & 0x200) != 0) {
            n3 = draftEditedChanges.endHour;
        }
        if ((n5 & 0x400) != 0) {
            n4 = draftEditedChanges.endMinute;
        }
        if ((n5 & 0x800) != 0) {
            string6 = draftEditedChanges.genreList;
        }
        if ((n5 & 0x1000) != 0) {
            list = draftEditedChanges.socialList;
        }
        if ((n5 & 0x2000) != 0) {
            string7 = draftEditedChanges.newSocial;
        }
        if ((n5 & 0x4000) != 0) {
            list2 = draftEditedChanges.conflicts;
        }
        return draftEditedChanges.copy(string2, string3, string4, imageType, string5, localDate, n, n2, localDate2, n3, n4, string6, list, string7, list2);
    }

    @NotNull
    public String toString() {
        return "DraftEditedChanges(performanceId=" + this.performanceId + ", artistName=" + this.artistName + ", description=" + this.description + ", imageType=" + this.imageType + ", stageKey=" + this.stageKey + ", startDay=" + this.startDay + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ", endDay=" + this.endDay + ", endHour=" + this.endHour + ", endMinute=" + this.endMinute + ", genreList=" + this.genreList + ", socialList=" + this.socialList + ", newSocial=" + this.newSocial + ", conflicts=" + this.conflicts + ")";
    }

    public int hashCode() {
        int result = this.performanceId.hashCode();
        result = result * 31 + this.artistName.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.imageType.hashCode();
        result = result * 31 + this.stageKey.hashCode();
        result = result * 31 + this.startDay.hashCode();
        result = result * 31 + Integer.hashCode(this.startHour);
        result = result * 31 + Integer.hashCode(this.startMinute);
        result = result * 31 + this.endDay.hashCode();
        result = result * 31 + Integer.hashCode(this.endHour);
        result = result * 31 + Integer.hashCode(this.endMinute);
        result = result * 31 + this.genreList.hashCode();
        result = result * 31 + ((Object)this.socialList).hashCode();
        result = result * 31 + this.newSocial.hashCode();
        result = result * 31 + ((Object)this.conflicts).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DraftEditedChanges)) {
            return false;
        }
        DraftEditedChanges draftEditedChanges = (DraftEditedChanges)other;
        if (!Intrinsics.areEqual((Object)this.performanceId, (Object)draftEditedChanges.performanceId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artistName, (Object)draftEditedChanges.artistName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)draftEditedChanges.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.imageType, (Object)draftEditedChanges.imageType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stageKey, (Object)draftEditedChanges.stageKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDay, (Object)draftEditedChanges.startDay)) {
            return false;
        }
        if (this.startHour != draftEditedChanges.startHour) {
            return false;
        }
        if (this.startMinute != draftEditedChanges.startMinute) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDay, (Object)draftEditedChanges.endDay)) {
            return false;
        }
        if (this.endHour != draftEditedChanges.endHour) {
            return false;
        }
        if (this.endMinute != draftEditedChanges.endMinute) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.genreList, (Object)draftEditedChanges.genreList)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.socialList, draftEditedChanges.socialList)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newSocial, (Object)draftEditedChanges.newSocial)) {
            return false;
        }
        return Intrinsics.areEqual(this.conflicts, draftEditedChanges.conflicts);
    }

    public DraftEditedChanges() {
        this(null, null, null, null, null, null, 0, 0, null, 0, 0, null, null, null, null, Short.MAX_VALUE, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lui/screens/draftSchedule/DraftEditedChanges$Companion;", "", "<init>", "()V", "NotEditing", "Lui/screens/draftSchedule/DraftEditedChanges;", "from", "addPerformanceType", "Lui/screens/draftSchedule/AddPerformanceType;", "festivalDay", "Lui/screens/FestivalDay;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DraftEditedChanges NotEditing() {
            return new DraftEditedChanges(null, null, null, null, null, null, 0, 0, null, 0, 0, null, null, null, null, Short.MAX_VALUE, null);
        }

        @NotNull
        public final DraftEditedChanges from(@NotNull AddPerformanceType addPerformanceType, @NotNull FestivalDay festivalDay2) {
            Intrinsics.checkNotNullParameter((Object)addPerformanceType, (String)"addPerformanceType");
            Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
            return new DraftEditedChanges(addPerformanceType.performanceId(), addPerformanceType.artistName(), addPerformanceType.description(), addPerformanceType.imageUrl(), addPerformanceType.stageKey(), addPerformanceType.startDayOfMonth(festivalDay2), addPerformanceType.startDayHour(festivalDay2), addPerformanceType.startDayMinute(), addPerformanceType.endDayOfMonth(festivalDay2), addPerformanceType.endDayHour(festivalDay2), addPerformanceType.endDayMinute(), addPerformanceType.genreList(), addPerformanceType.socialList(), null, null, 24576, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

